//Constants.
var bLoad=false
var bPureText=true
var bodyStyle="<BODY MONOSPACE STYLE=\"font:10pt arial,sans-serif\">"
var bSendAsText=false
var exp = /(^\s*)|(\s*$)/g;

public_description=new Editor

function Editor() {
  this.put_html=SetHtml;
  this.get_html=GetHtml;
  this.put_text=SetText;
  this.get_text=GetText;
  this.CompFocus=GetCompFocus;
}

function GetCompFocus() {
  HtmlEditor.focus();
}

function GetText() {
  return HtmlEditor.document.body.innerText;
}

function SetText(text) {
  text = text.replace(/\n/g, "<br>")
  HtmlEditor.document.body.innerHTML=text;
}
 
function GetHtml() {
  if (bSendAsText) 
    return HtmlEditor.document.body.innerText;
  else {
    cleanHtml();
    return HtmlEditor.document.body.innerHTML;
  }
}

function SetHtml(sHtml) {
  if (bSendAsText) HtmlEditor.document.body.innerText=sHtml;
  else HtmlEditor.document.body.innerHTML=sHtml;
}


SEP_PADDING = 5
HANDLE_PADDING = 7

var yToolbars = new Array(); 

var bInitialized = false;
function document.onreadystatechange() {
  if (bInitialized) return;
  bInitialized = true;

  var i, s, curr;

  // Find all the toolbars and initialize them.
  for (i=0; i<document.body.all.length; i++) {
    curr=document.body.all[i];
    if (curr.className == "yToolbar") {
      if (! InitTB(curr)) {
        alert("Toolbar: " + curr.id + " failed to initialize. Status: false");
      }
      yToolbars[yToolbars.length] = curr;
    }
  }

  //Lay out the page, set handler.
  DoLayout();
  window.onresize = DoLayout;

  //HtmlEditor.document.open()
  //HtmlEditor.document.write("<BODY MONOSPACE STYLE=font:10pt arial,sans-serif></body>");
  //HtmlEditor.document.close()
  //HtmlEditor.document.designMode="On"
  //setTimeout("HtmlEditor.focus()",0)

}

// Initialize a toolbar button
function InitBtn(btn) {
  btn.onmouseover = BtnMouseOver;
  btn.onmouseout = BtnMouseOut;
  btn.onmousedown = BtnMouseDown;
  btn.onmouseup = BtnMouseUp;
  btn.ondragstart = YCancelEvent;
  btn.onselectstart = YCancelEvent;
  btn.onselect = YCancelEvent;
  btn.YUSERONCLICK = btn.onclick;
  btn.onclick = YCancelEvent;
  btn.bInitialized = true;
  return true;
}

//Initialize a toolbar. 
function InitTB(y) {
  // Set initial size of toolbar to that of the handle
  y.TBWidth = 0;
    
  // Populate the toolbar with its contents
  if (! PopulateTB(y)) return false;
  
  // Set the toolbar width and put in the handle
  y.style.posWidth = y.TBWidth;
  
  return true;
}


// Hander that simply cancels an event
function YCancelEvent() {
  event.returnValue=false;
  event.cancelBubble=true;
  return false;
}

// Toolbar button onmouseover handler
function BtnMouseOver() {
  if (event.srcElement.tagName != "IMG") return false;
  var image = event.srcElement;
  var element = image.parentElement;
  
  // Change button look based on current state of image.
  if (image.className == "Ico") element.className = "BtnMouseOverUp";
  else if (image.className == "IcoDown") element.className = "BtnMouseOverDown";

  event.cancelBubble = true;
}

// Toolbar button onmouseout handler
function BtnMouseOut() {
  if (event.srcElement.tagName != "IMG") {
    event.cancelBubble = true;
    return false;
  }

  var image = event.srcElement;
  var element = image.parentElement;
  yRaisedElement = null;
  
  element.className = "Btn";
  image.className = "Ico";

  event.cancelBubble = true;
}

// Toolbar button onmousedown handler
function BtnMouseDown() {
  if (event.srcElement.tagName != "IMG") {
    event.cancelBubble = true;
    event.returnValue=false;
    return false;
  }

  var image = event.srcElement;
  var element = image.parentElement;

  element.className = "BtnMouseOverDown";
  image.className = "IcoDown";

  event.cancelBubble = true;
  event.returnValue=false;
  return false;
}

// Toolbar button onmouseup handler
function BtnMouseUp() {
  if (event.srcElement.tagName != "IMG") {
    event.cancelBubble = true;
    return false;
  }

  var image = event.srcElement;
  var element = image.parentElement;

  if (element.YUSERONCLICK) eval(element.YUSERONCLICK + "anonymous()");

  element.className = "BtnMouseOverUp";
  image.className = "Ico";

  event.cancelBubble = true;
  return false;
}

// Populate a toolbar with the elements within it
function PopulateTB(y) {
  var i, elements, element;

  // Iterate through all the top-level elements in the toolbar
  elements = y.children;
  for (i=0; i<elements.length; i++) {
    element = elements[i];
    if (element.tagName == "SCRIPT" || element.tagName == "!") continue;
    
    switch (element.className) {
    case "Btn":
      if (element.bInitialized == null) {
	if (! InitBtn(element)) {
	  alert("Problem initializing:" + element.id);
	  return false;
	}
      }
      
      element.style.posLeft = y.TBWidth;
      y.TBWidth += element.offsetWidth + 1;
      break;
      
    case "TBGen":
      element.style.posLeft = y.TBWidth;
      y.TBWidth += element.offsetWidth + 1;
      break;
      
    case "TBSep":
      element.style.posLeft = y.TBWidth + 2;
      y.TBWidth += SEP_PADDING;
      break;
      
    case "TBHandle":
      element.style.posLeft = 2;
      y.TBWidth += element.offsetWidth + HANDLE_PADDING;
      break;
      
    default:
      alert("Invalid class: " + element.className + " on Element: " + element.id + " <" + element.tagName + ">");
      return false;
    }
  }

  y.TBWidth += 1;
  return true;
}

function DebugObject(obj) {
  var msg = "";
  for (var i in TB) {
    ans=prompt(i+"="+TB[i]+"\n");
    if (! ans) break;
  }
}

// Lay out the docked toolbars
function LayoutTBs() {
  NumTBs = yToolbars.length;

  // If no toolbars we're outta here
  if (NumTBs == 0) return;

  //Get the total size of a TBline.
  var i;
  var ScrWid = (document.body.offsetWidth) - 6;
  var TotalLen = ScrWid;
  for (i = 0 ; i < NumTBs ; i++) {
    TB = yToolbars[i];
    if (TB.TBWidth > TotalLen) TotalLen = TB.TBWidth;
  }

  var PrevTB;
  var LastStart = 0;
  var RelTop = 0;
  var LastWid, CurrWid;

  //Set up the first toolbar.
  var TB = yToolbars[0];
  TB.style.posTop = 0;
  TB.style.posLeft = 0;

  //Lay out the other toolbars.
  var Start = TB.TBWidth;
  for (i = 1 ; i < yToolbars.length ; i++) {
    PrevTB = TB;
    TB = yToolbars[i];
    CurrWid = TB.TBWidth;

    if ((Start + CurrWid) > ScrWid) { 
      //TB needs to go on next line.
      Start = 0;
      LastWid = TotalLen - LastStart;
    } 
    else { 
      //Ok on this line.
      LastWid = PrevTB.TBWidth;
      //RelTop -= TB.style.posHeight;
      RelTop -= TB.offsetHeight;
    }
      
    //Set TB position and LastTB width.
    TB.style.posTop = RelTop;
    TB.style.posLeft = Start;
    PrevTB.style.width = LastWid;

    //Increment counters.
    LastStart = Start;
    Start += CurrWid;
  } 

  //Set width of last toolbar.
  TB.style.width = TotalLen - LastStart;
  
  //Move everything after the toolbars up the appropriate amount.
  i--;
  TB = yToolbars[i];
  var TBInd = TB.sourceIndex;
  var A = TB.document.all;
  var item;
  for (i in A) {
    item = A.item(i);
    if (! item) continue;
    if (! item.style) continue;
    if (item.sourceIndex <= TBInd) continue;
    if (item.style.position == "absolute") continue;
    item.style.posTop = RelTop;
  }
}

//Lays out the page.
function DoLayout() {
  LayoutTBs();
}

// Check if toolbar is being used when in text mode
function validateMode() {
  if (! bSendAsText) return true;
  alert("Please uncheck the \"View HTML source\" checkbox to use the toolbars");
  HtmlEditor.focus();
  return false;
}

//Formats text in HtmlEditor.
function format(what,opt) {
  if (!validateMode()) return;
  
  if (opt=="removeFormat") {
    what=opt;
    opt=null;
  }

  if (opt==null) HtmlEditor.document.execCommand(what);
  else HtmlEditor.document.execCommand(what,"",opt);
  
  bPureText = false;
  HtmlEditor.focus();
}

//Switches between text and html mode.
function setMode(newMode) {
  bSendAsText = newMode;
  var cont;
  if (bSendAsText) {
    cleanHtml();
    cleanHtml();

    cont=HtmlEditor.document.body.innerHTML;
    HtmlEditor.document.body.innerText=cont;
  } else {
    cont=HtmlEditor.document.body.innerText;
    HtmlEditor.document.body.innerHTML=cont;
  }
  
  HtmlEditor.focus();
}

//Finds and returns an element.
function getEl(sTag,start) {
  while ((start!=null) && (start.tagName!=sTag)) start = start.parentElement;
  return start;
}

function createLink() {
  if (!validateMode()) return;
  
  var isA = getEl("A",HtmlEditor.document.selection.createRange().parentElement());
  var str=prompt("Enter link location (e.g. http://www.xxx.com):", isA ? isA.href : "http:\/\/");
  
  if ((str!=null) && (str!="http://")) {
    if (HtmlEditor.document.selection.type=="None") {
      var sel=HtmlEditor.document.selection.createRange();
      sel.pasteHTML("<A href="+str+" target=_blank>"+str+"</A> ");
      sel.select();
    }
    else format("CreateLink",str);
  }
  else HtmlEditor.focus();
}

function createEmail() {
  if (!validateMode()) return;
  
  var isA = getEl("A",HtmlEditor.document.selection.createRange().parentElement());
  var str=prompt("Enter e-mail (e.g. master@xxx.com):", isA ? isA.href : "");
  
  if ((str!=null) && (str!="") && (str.indexOf("@") != -1) && (str.indexOf(".") != -1) && (str.length > 6)) {
    if (HtmlEditor.document.selection.type=="None") {
      var sel=HtmlEditor.document.selection.createRange();
      sel.pasteHTML("<A HREF=mailto:"+str+">"+str+"</A> ");
      sel.select();
    }
    else format("CreateEmail",str);
  }
  else HtmlEditor.focus();
}

function createFlash()
{
	if (!validateMode()) return;
	var wh = prompt("FlashļĿ͸ߣ (磺500,400):","500,400");
	wh = wh.replace(exp,"");
	while (wh != null)
	{
		if (wh!=null && wh!="" && wh.indexOf(",")!=-1)
		{
			var w = wh.substr(0,wh.indexOf(","));
			var h = wh.substr(wh.indexOf(",")+1,wh.length-wh.indexOf(",")-1);
			var isA = getEl("A",HtmlEditor.document.selection.createRange().parentElement());
			var str=prompt("Flashļĵַ (e.g. http://www.haina.com/swf/haina.swf):", isA ? isA.href : "http:\/\/");
			str = str.replace(exp,"");
			if ((str!=null) && (str!="") && (str!="http://") && (str.length > 4) && (str.substr(str.length-3,3).toLowerCase()=="swf"))
			{
				if (HtmlEditor.document.selection.type=="None")
				{
					var sel=HtmlEditor.document.selection.createRange();
					sel.pasteHTML("<object classid=clsid:D27CDB6E-AE6D-11cf-96B8-444553540000 codebase=http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,29,0 width=" + w + " height=" + h + "><param name=movie value=" + str + "><param name=quality value=high><PARAM NAME=menu VALUE=false><embed src=" + str + " quality=high pluginspage=http://www.macromedia.com/go/getflashplayer type=application/x-shockwave-flash width=" + w + " height=" + h + "> </embed></object>");
					sel.select();
				}
				else format("CreateFlash",str);
			}
			else HtmlEditor.focus();
			break;
		}
		else
		{
			alert("밴ȷʽдߣ");
			wh = prompt("FlashļĿ͸ߣ (磺500,400):","500,400");
		}
	}
	HtmlEditor.focus();
}

function createRm()
{
	if (!validateMode()) return;
	var wh = prompt("RealplayƵļĿ͸ߣ (磺250,50):","250,50");
	wh = wh.replace(exp,"");
	while (wh != null)
	{
		if (wh!=null && wh!="" && wh.indexOf(",")!=-1)
		{
			var w = wh.substr(0,wh.indexOf(","));
			var h = wh.substr(wh.indexOf(",")+1,wh.length-wh.indexOf(",")-1);
			var isA = getEl("A",HtmlEditor.document.selection.createRange().parentElement());
			var str=prompt("RealplayƵļĵַ (e.g. rtsp://www.haina.com/rm/haina.rm):", isA ? isA.href : "http:\/\/");
			str = str.replace(exp,"");
			if ((str!=null) && (str!="") && (str!="http://") && (str.length > 4) && (str.substr(str.length-3,3).toLowerCase()=="ram" || str.substr(str.length-2,2).toLowerCase()=="rm"))
			{
				if (HtmlEditor.document.selection.type=="None")
				{
					var sel=HtmlEditor.document.selection.createRange();
					sel.pasteHTML("<object classid=clsid:CFCDAA03-8BE4-11CF-B84B-0020AFBBCCFA id=RAOCX width=" + w + " height="+ h + "><param name=_ExtentX value=12383><param name=_ExtentY value=1667><param name=AUTOSTART value=1><param name=SHUFFLE value=0><param name=PREFETCH value=0><param name=NOLABELS value=0><param name=SRC value=" + str + "><param name=CONTROLS value=StatusBar,ControlPanel><param name=LOOP value=0><param name=NUMLOOP value=0><param name=CENTER value=0><param name=MAINTAINASPECT value=0><param name=BACKGROUNDCOLOR value=#000000><embed src=" + str + " width=" + w + " autostart=true height=" + h + "></embed></object>");
					sel.select();
				}
				else format("CreateRm",str);
			}
			else HtmlEditor.focus();
			break;
		}
		else
		{
			alert("밴ȷʽдߣ");
			wh = prompt("RealplayƵļĿ͸ߣ (磺250,50):","250,50");
		}
	}
	HtmlEditor.focus();
}

function createShockwave()
{
	if (!validateMode()) return;
	var wh = prompt("ShockwaveƵļĿ͸ߣ (磺500,400):","500,400");
	wh = wh.replace(exp,"");
	while (wh != null)
	{
		if (wh!=null && wh!="" && wh.indexOf(",")!=-1)
		{
			var w = wh.substr(0,wh.indexOf(","));
			var h = wh.substr(wh.indexOf(",")+1,wh.length-wh.indexOf(",")-1);
			var isA = getEl("A",HtmlEditor.document.selection.createRange().parentElement());
			var str=prompt("ShockwaveƵļĵַ (e.g. http://www.haina.com/shockwave/haina.dcr):", isA ? isA.href : "http:\/\/");
			str = str.replace(exp,"");
			if ((str!=null) && (str!="") && (str!="http://") && (str.length > 4) && (str.substr(str.length-3,3).toLowerCase()=="dcr"))
			{
				if (HtmlEditor.document.selection.type=="None")
				{
					var sel=HtmlEditor.document.selection.createRange();
					sel.pasteHTML("<object classid=clsid:166B1BCA-3F9C-11CF-8075-444553540000 codebase=http://download.macromedia.com/pub/shockwave/cabs/director/sw.cab#version=7,0,2,0 width=" + w + " height=" + h + "><param name=src value=" + str + "><embed src=" + str + " pluginspage=http://www.macromedia.com/shockwave/download/ width=" + w + " height=" + h + "></embed></object>");
					sel.select();
				}
				else format("createShockwave",str);
			}
			else HtmlEditor.focus();
			break;
		}
		else
		{
			alert("밴ȷʽдߣ");
			wh = prompt("ShockwaveƵļĿ͸ߣ (磺500,400):","500,400");
		}
	}
	HtmlEditor.focus();
}

function createMedia()
{
	if (!validateMode()) return;
	var wh = prompt("Media PlayerƵļĿ͸ߣ (磺500,400):","500,400");
	wh = wh.replace(exp,"");
	while (wh != null)
	{
		if (wh!=null && wh!="" && wh.indexOf(",")!=-1)
		{
			var w = wh.substr(0,wh.indexOf(","));
			var h = wh.substr(wh.indexOf(",")+1,wh.length-wh.indexOf(",")-1);
			var isA = getEl("A",HtmlEditor.document.selection.createRange().parentElement());
			var str=prompt("Media PlayerƵļĵַ (e.g. http://www.haina.com/media/haina.wmv):", isA ? isA.href : "http:\/\/");
			str = str.replace(exp,"");
			if ((str!=null) && (str!="") && (str!="http://") && (str.length > 4) && (str.substr(str.length-3,3).toLowerCase()=="wmv"))
			{
				if (HtmlEditor.document.selection.type=="None")
				{
					var sel=HtmlEditor.document.selection.createRange();
					sel.pasteHTML("<object align=middle classid=CLSID:22d6f312-b0f6-11d0-94ab-0080c74c7e95 class=OBJECT id=MediaPlayer width=" + w + " height=" + h + "><param name=ShowStatusBar value=-1><param name=Filename value=" + str + "><embed type=application/x-oleobject codebase=http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701 flename=mp src=" + str + " width=" + w + " height=" + h + "></embed></object>");
					sel.select();
				}
				else format("createMedia",str);
			}
			else HtmlEditor.focus();
			break;
		}
		else
		{
			alert("밴ȷʽдߣ");
			wh = prompt("Media PlayerƵļĿ͸ߣ (磺500,400):","500,400");
		}
	}
	HtmlEditor.focus();
}

function createQt()
{
	if (!validateMode()) return;
	var wh = prompt("QuickTimeƵļĿ͸ߣ (磺500,400):","500,400");
	wh = wh.replace(exp,"");
	while (wh != null)
	{
		if (wh!=null && wh!="" && wh.indexOf(",")!=-1)
		{
			var w = wh.substr(0,wh.indexOf(","));
			var h = wh.substr(wh.indexOf(",")+1,wh.length-wh.indexOf(",")-1);
			var isA = getEl("A",HtmlEditor.document.selection.createRange().parentElement());
			var str=prompt("QuickTimeƵļĵַ (e.g. http://www.haina.com/quicktime/haina.mov):", isA ? isA.href : "http:\/\/");
			str = str.replace(exp,"");
			if ((str!=null) && (str!="") && (str!="http://") && (str.length > 4) && (str.substr(str.length-3,3).toLowerCase()=="mov"))
			{
				if (HtmlEditor.document.selection.type=="None")
				{
					var sel=HtmlEditor.document.selection.createRange();
					sel.pasteHTML("<blockquote><embed src=" + str + " width=" + w + " height=" + h + " autoplay=true loop=false controller=true playeveryframe=false cache=false scale=TOFIT bgcolor=#000000 kioskmode=false targetcache=false pluginspage=http://www.apple.com/quicktime/></blockquote>");
					sel.select();
				}
				else format("createQt",str);
			}
			else HtmlEditor.focus();
			break;
		}
		else
		{
			alert("밴ȷʽдߣ");
			wh = prompt("QuickTimeƵļĿ͸ߣ (磺500,400):","500,400");
		}
	}
	HtmlEditor.focus();
}

//Sets the text color.
function foreColor() {
  if (! validateMode()) return;
  var arr = showModalDialog("ColorSelect.htm", "", "font-family:Verdana; font-size:12; dialogWidth:30em; dialogHeight:35em");
  if (arr != null) format('forecolor', arr);
  else HtmlEditor.focus();
}

//Sets the background color.
function backColor() {
  if (!validateMode()) return;
  var arr = showModalDialog("ColorSelect.htm", "", "font-family:Verdana; font-size:12; dialogWidth:30em; dialogHeight:35em");
  if (arr != null) format('backcolor', arr);
  else HtmlEditor.focus()
}

//Sets the fly.
function Flying(){
  if (!validateMode()) return;
  var range = HtmlEditor.document.selection.createRange();
  var str = range.text;
  //var str1 = "[FLY]"+str+"[/FLY]";
  //range.text = str1;
  //var tstr = HtmlEditor.document.body.innerHTML;
  //HtmlEditor.document.body.innerHTML = tstr.replace(str1,"<marquee behavior=alternate scrollamount=3>"+str+"</marquee>");
  range.pasteHTML("<marquee behavior=alternate scrollamount=3>"+str+"</marquee>");
  range.select();
  HtmlEditor.focus();
}

//Sets the move.
function Moving(){
  if (!validateMode()) return;
  var range = HtmlEditor.document.selection.createRange();
  var str = range.text;
  //var str1 = "[MOVE]"+str+"[/MOVE]";
  //range.text = str1;
  //var tstr = HtmlEditor.document.body.innerHTML;
  //HtmlEditor.document.body.innerHTML = tstr.replace(str1,"<marquee scrollamount=3>"+str+"</marquee>");
  range.pasteHTML("<marquee scrollamount=3>"+str+"</marquee>");
  range.select();
  HtmlEditor.focus();
}

//Sets the glow.
function Glowing(){
  if (!validateMode()) return;
  var z1 = prompt("ɫ (磺red#FF0000):","red");
  if (z1 == null || z1 == "")
  {
	  z1 = "red";
  }
  z1 = z1.toLowerCase();
  var z2 = prompt("ߴС (磺2):","2");
  if (z2 == null || z1 == "")
  {
	  z2 = "2";
  }
  z2 = z2.toLowerCase();
  var range = HtmlEditor.document.selection.createRange();
  var str = range.text;
  var str1 = "[GLOW]"+str+"[/GLOW]";
  range.text = str1;
  var tstr = HtmlEditor.document.body.innerHTML;
  HtmlEditor.document.body.innerHTML = tstr.replace(str1,"<style type=text/css>.glow_" + z1 + "_" + z2 + "{filter:glow(color=" + z1 + ", strength=" + z2 + ")}</style><table><tr><td class=glow_" + z1 + "_" + z2 + ">"+str+"</td></tr></table>");
  //range.pasteHTML("<style type=text/css>.glow_" + z1 + "_" + z2 + "{filter:glow(color=" + z1 + ", strength=" + z2 + ")}</style><table><tr><td class=glow_" + z1 + "_" + z2 + ">"+str+"</td></tr></table>");
  //range.select();
  HtmlEditor.focus();
}

//Sets the shadow.
function Shadowing(){
  if (!validateMode()) return;
  var z1 = prompt("ɫ (磺red#FF0000):","red");
  if (z1 == null || z1 == "")
  {
	  z1 = "red";
  }
  z1 = z1.toLowerCase();
  var z2 = prompt("ӰС (磺1):","1");
  if (z2 == null || z1 == "")
  {
	  z2 = "1";
  }
  z2 = z2.toLowerCase();
  var range = HtmlEditor.document.selection.createRange();
  var str = range.text;
  var str1 = "[SHADOW]"+str+"[/SHADOW]";
  range.text = str1;
  var tstr = HtmlEditor.document.body.innerHTML;
  HtmlEditor.document.body.innerHTML = tstr.replace(str1,"<style type=text/css>.shadow_" + z1 + "_" + z2 + "{filter:shadow(color=" + z1 + ", strength=" + z2 + ")}</style><table><tr><td class=shadow_" + z1 + "_" + z2 + ">"+str+"</td></tr></table>");
  //range.pasteHTML("<style type=text/css>.shadow_" + z1 + "_" + z2 + "{filter:shadow(color=" + z1 + ", strength=" + z2 + ")}</style><table><tr><td class=shadow_" + z1 + "_" + z2 + ">"+str+"</td></tr></table>");
  //range.select();
  HtmlEditor.focus();
}

//Sets the quote.
function Quote(){
  if (!validateMode()) return;
  var tstr = HtmlEditor.document.body.innerHTML;
  HtmlEditor.document.body.innerHTML = "<table border=0 cellpadding=1 cellspacing=1 bgcolor=#000000><tr bgcolor=#FFFFFF><td>" + tstr + "</td></tr></table>";
  HtmlEditor.focus();
}

function insertImage() {
  HtmlEditor.focus();
  if (!validateMode()) return;
  var arr = showModalDialog("/inc/insertImage.html" + document.location.search, "linkpic", "dialogWidth:25em; dialogHeight:9em; status:0");
  if (arr==null) return;
  var tmp;
  tmp=arr.split("*");
  var pathimg=tmp[0];
  var align=tmp[1];
  var demo=tmp[2];
	if (pathimg!=null)
	{
		sh = pathimg.substr(0,7);
			var string;
			if (align=="sys")
				if (demo != "")
				{
		  			string="<img alt="+demo+" src="+pathimg+" border=0>";
				}
				else string="<img src="+pathimg+" border=0>";
		  else
				if (demo != "")
				{
		  			string="<img alt="+demo+" src="+pathimg+" align="+align+" border=0>";
				}
				else string="<img src="+pathimg+" align="+align+" border=0>";
		  content=HtmlEditor.document.body.innerHTML;
		  content=content+string;
		  HtmlEditor.document.body.innerHTML=content;
	}
  HtmlEditor.focus();
}

function cleanHtml() {
  var fonts = HtmlEditor.document.body.all.tags("FONT");
  var curr;
  for (var i = fonts.length - 1; i >= 0; i--) {
    curr = fonts[i];
    if (curr.style.backgroundColor == "#ffffff") curr.outerHTML = curr.innerHTML;
  }
}

function getPureHtml() {
  var str = "";
  var paras = HtmlEditor.document.body.all.tags("P");
  if (paras.length > 0) {
    for (var i=paras.length-1; i >= 0; i--) str = paras[i].innerHTML + "\n" + str;
  } else {
    str = HtmlEditor.document.body.innerHTML;
  }
  return str;
}

// Local Variables:
// c-basic-offset: 2
// End:
  