(defun in_box (p1 p2 / pcode ltd tf lt g1 g2)
  (defun pcode (pt / code)
    (setq code (cond ((< (car pt) (caar ltw)) 1)
		     ((> (car pt) (caadr ltw)) 2)
		     (T 0)
	       )
    )
    (cond ((< (cadr pt) (cadr (last ltw))) (+ code 4))
	  ((> (cadr pt) (cadar ltw)) (+ code 8))
	  (T code)
    )
  )
  (setq	g1 (pcode p1)
	g2 (pcode p2)
  )
  (cond
    ((/= (logand g1 g2) 0) nil)
    ((and (= g1 0) (= g2 0)) T)
    (T
     (setq ltd (mapcar '(lambda (x) (p_l x p1 p2)) ltw))
     (foreach x	ltd
       (if (equal x 0 1e-4)
	 (setq tf T)
	 (setq lt (cons x lt))
       )
     )
     (if tf
       tf
       (progn (setq tf (> (car ltd) 0))
	      (while (and (setq ltd (cdr ltd)) (eq tf (> (car ltd) 0))))
	      ltd
       )
     )
    )
  )
)
(defun ve_face (/ i vf ps pe num lt)
  (setq	i  0
	ps (socas 10)
	vf (socas 70)
	lt 0
  )
  (while (< i 4)
    (setq num (nth i '(1 2 4 8))
	  pe  (socas (if (= i 3)
		       10
		       (+ 11 i)
		     )
	      )
    )
    (if	(and (not (or (= (logand vf num) num) (equal ps pe 1e-4)))
	     (in_box (trans ps 0 2) (trans pe 0 2))
	     (or (not num_hide) (/= (logand num num_hide) 0))
	)
      (setq lt (+ num lt))
    )
    (setq ps pe
	  i  (1+ i)
    )
  )
  (setvar "splframe" 0)
  (modent 70 (logior vf lt))
)
(defun p_edge (pt / sel_pt p_on_l st num wzq)
  (defun p_on_l	(pt p1 p2 / a b c)
    (equal (+ (distance p1 pt) (distance pt p2))
	   (distance p1 p2)
	   1e-4
    )
  )
  (setq st (#selpt pt '((0 . "3DFACE"))))
  (if st
    (progn
      (getss st 0)
      (while (namess 0)
	(setq num 10)
	(while (and (not (p_on_l pt
				 (socas num)
				 (socas	(if (> (setq num (1+ num)) 13)
					  10
					  num
					)
				 )
			 )
		    )
		    (< num 14)
	       )
	)
	(setq num (cadr (assoc num '((11 1) (12 2) (13 4) (14 8)))))
	(setvar "splframe" 0)
	(setq wzq (socas 70)
	      wzq (logior wzq num)
	)
	(modent 70 wzq)
      )
    )
  )
)
(defun win_hide	(/ p1 p2 st e1 lt a ltw dr ltc wzq)
  (setq	p1 (getpoint "\nCڵһ: ")
	p2 (if p1
	     (getcorner "\nCһ: " p1)
	   )
  )
  (if p2
    (progn (setvar "osmode" 0)
	   (setq st (ssget "c" p1 p2 '((0 . "3DFACE"))))
    )
  )
  (if st
    (progn (prompt "\nRȥѡеĶ: ")
	   (command ".select" st pause)
	   (setq st (ssget "p" '((0 . "3DFACE"))))
	   (setq p1 (trans p1 0 2)
		 p2 (trans p2 0 2)
		 p2 (list (car p2) (cadr p2) (caddr p1))
		 dr (/ (distance p1 p2) 2)
		 p1 (midp p1 p2)
		 a  (angle p1 p2)
	   )
	   (if (> a pi)
	     (setq a (- a pi))
	   )
	   (if (> a (/ pi 2))
	     (setq a (- pi a))
	   )
	   (setq ltw (list (polar p1 (- pi a) dr)
			   (polar p1 a dr)
			   (polar p1 (- a) dr)
			   (polar p1 a (- dr))
		     )
	   )
	   (getss st 0)
	   (while (setq e1 (namess 0)) (ve_face))
    )
    (prompt
      "\n* δѡ3DFACE, Ϊк, תΪ[߱]."
    )
  )
)
(defun c:3d_hide (/ num_hide pt tf)
  (command ".ucs" "")
  (setq tf T)
  (while tf
    (setvar "osmode" 512)
    (initget "V H C")
    (setq pt (getpoint "\nV-ȥ/ H-ȥ/ C-/ <ȡ>: "))
    (setvar "osmode" 0)
    (cond ((not pt) (setq tf nil))
	  ((listp pt) (p_edge pt))
	  (T
	   (setq num_hide (cond	((= pt "V") 10)
				((= pt "H") 5)
			  )
	   )
	   (win_hide)
	   (setq tf nil)
	  )
    )
  )
  (princ)
)
(defun c:unhide	(/ ep st)
  (setq st (ssget '((0 . "3DFACE"))))
  (getss st 0)
  (while (namess 0)
    (getent (car ep))
    (if	(/= (socas 70) 0)
      (modent 70 0)
    )
  )
  (princ)
)
(defun c:3d_ctrl (/ n str)
  (if (= (getvar "splframe") 0)
    (setq n   1
	  str "\n"
    )
    (setq n   0
	  str "\n"
    )
  )
  (prompt (strcat str "ʾر."))
  (setvar "splframe" n)
  (command ".regen")
  (princ)
)
(defun c:div_accu (/ n str)
  (setq	div_accu (if (numberp div_accu)
		   div_accu
		   50.0
		 )
  )
  (initget 6)
  (setq	wzq (getreal (strcat "\n趨µĻҾֵ <"
			     (rtos div_accu 2 1)
			     ">: "
		     )
	    )
  )
  (if wzq
    (setq div_accu wzq)
  )
)
(defun c:clmn3d	(/ en cp r p1 lt a y wzq)
  (prompt "\nѡҪ3DFACEʾά <˳>: ")
  (setq st (ssget (list '(0 . "INSERT") (cons 8 (glayer "ά")))))
  (begin "ά")
  (getss st 0)
  (while (namess 0)
    (setq en (socas 2))
    (cond ((= en "_3DYZ")
	   (setq cp (socas 10)
		 r  (* 0.5 (socas 41))
		 p1 (polar cp 0 r)
		 lt (#div_poly (list p1 1.0 (polar cp pi r) 1.0 p1))
	   )
	  )
	  ((= en "_3DFZ")
	   (setq cp  (socas 10)
		 a   (socas 50)
		 r   (* 0.5 (socas 41))
		 y   (* 0.5 (socas 42))
		 wzq (polar cp a r)
		 cp  (polar cp a (- r))
		 p1  (polar wzq (- a _pi2) y)
		 lt  (list p1
			   (polar wzq (+ a _pi2) y)
			   (polar cp (+ a _pi2) y)
			   (polar cp (- a _pi2) y)
			   p1
		     )
	   )
	  )
	  (T (setq lt nil))
    )
    (if	lt
      (progn (entdel (socas -1))
	     (command ".elev" (caddar lt) (socas 43))
	     (apply 'command (cons ".LINE" lt))
	     (command "" "elev" 0 0)
      )
    )
  )
  (end)
)
(defun c:3dczmg	()
  (prompt
    "\nϲظ߶ȷӵά. ѡȡϲ <˳>: "
  )
  (zmg_blk "ά")
)
(defun c:3dwzmg	()
  (prompt
    "\nϲظ߶ȷӵάǽ. ѡȡϲǽ <˳>: "
  )
  (zmg_la "άǽ")
)
(defun c:tl3d (/ st z1 e1 la lt lt1 nm ecs)
  (_@ld "wzqlib")
  (prompt
    "\nкתΪά(3DFACE)ʾ. ѡҪתк <˳>: "
  )
  (setq
    st (ssget
	 '((0 . "LINE,ARC,CIRCLE,*POLYLINE") (-4 . "/=") (39 . 0.0))
       )
  )
  (getss st 0)
  (while (setq e1 (namess 0))
    (setq nm  (socas 0)
	  la  (socas 8)
	  la  (socas 8)
	  ecs (socas 210)
	  lt  (cond ((= nm "LINE")
		     (mapcar '(lambda (x) (trans x 0 ecs))
			     (list (socas 10) (socas 11))
		     )
		    )
		    ((or (= nm "ARC") (= nm "CIRCLE")) (#poly_inarc e1 nil))
		    ((wcmatch nm "*POLYLINE") (#div_poly e1))
	      )
    )
    (setq z1 (+ (caddr (car lt)) (socas 39)))
    (setq lt1 (mapcar '(lambda (x) (list (car x) (cadr x) z1)) lt))
    (if	(not (equal ecs '(0 0 1) 1e-4))
      (setq lt	(mapcar '(lambda (x) (trans x ecs 0)) lt)
	    lt1	(mapcar '(lambda (x) (trans x ecs 0)) lt1)
      )
    )
    (entdel e1)
    (while (cadr lt)
      (entmake (list '(0 . "3DFACE")
		     (cons 8 la)
		     (cons 10 (car lt))
		     (cons 11 (cadr lt))
		     (cons 12 (cadr lt1))
		     (cons 13 (car lt1))
	       )
      )
      (setq lt	(cdr lt)
	    lt1	(cdr lt1)
      )
    )
  )
  (princ)
)
(defun zmg_la (wzq / p1	p2 ps pe pm st e1 lt lt1 lt2 z1	zp n i j r info
	       tf)
  (if (setq st (ssget (list (cons 8 (glayer wzq))
			    '(0 . "LINE,ARC,CIRCLE,*POLYLINE")
		      )
	       )
      )
    (progn
      (setvar "highlight" 0)
      (command ".select" "p" "")
      (if (setq wzq (ssget "p" '((0 . "*POLYLINE"))))
	(progn (setq e1	(entlast)
		     i	-1
	       )
	       (while (setq i  (1+ i)
			    p1 (ssname wzq i)
		      )
		 (command ".explode" p1)
	       )
	       (prompt (strcat (itoa (sslength wzq)) "ֽ߱."))
	       (command ".select" st (#sel e1 (entlast)) "")
	       (setq st (ssget "p"))
	)
      )
      (setvar "highlight" 1)
      (prompt "\nغ߱Ƚ, Ҫϳʱ.  Ctrl+C ֹ.")
      (setq n -1)
      (while (setq n  (1+ n)
		   e1 (ssname st n)
	     )
	(setq wzq (entget e1)
	      zp  (cdr (assoc 39 wzq))
	      r	  (cdr (assoc 40 wzq))
	      p1  (cdr (assoc 10 wzq))
	)
	(if r
	  (setq	ps   (cdr (assoc 50 wzq))
		pe   (cdr (assoc 51 wzq))
		info (if ps
		       (atop T p1 r ps pe)
		       (atop T p1 r 0.0 359.9)
		     )
		p1   (car info)
		r    (cadr info)
		p2   (caddr info)
	  )
	  (setq	r  0
		p2 (cdr (assoc 11 wzq))
	  )
	)
	(setq z1   (caddr p1)
	      zp   (if zp
		     zp
		     0
		   )
	      p1   (list (car p1) (cadr p1))
	      p2   (list (car p2) (cadr p2))
	      pm   (midp p1 p2)
	      info (list p1 r p2)
	      j	   (length lt)
	      tf   T
	)
	(while (and tf (>= (setq j (1- j)) 0))
	  (setq	lt1 (nth j lt)
		wzq (last (last lt1))
	  )
	  (if (< (abs (- (car pm) (car (midp (car wzq) (caddr wzq)))))
		 2000.001
	      )
	    (progn (setq i -1)
		   (while (and tf
			       (setq i	 (1+ i)
				     lt2 (nth i lt1)
			       )
			  )
		     (setq wzq (last lt2))
		     (if (or (equal wzq info 1e-4)
			     (and (equal wzq (reverse info) 1e-4)
				  (= (cadr info) 0)
			     )
			 )
		       (setq wzq (cons (list z1 zp e1) lt2)
			     wzq (subst wzq lt2 lt1)
			     tf	 nil
		       )
		     )
		   )
		   (if tf
		     (setq wzq (cons (list (list z1 zp e1) info) lt1)
			   tf  nil
		     )
		   )
		   (setq lt (subst wzq lt1 lt))
	    )
	  )
	)
	(if tf
	  (setq lt (cons (list (list (list z1 zp e1) info)) lt))
	)
      )
      (if (setq lt (apply 'append lt))
	(prompt "\nȽ. ϲ...")
      )
      (foreach wzq lt
	(setq lt  (cdr (reverse wzq))
	      lt  (apply 'sort1 lt)
	      lt1 nil
	      lt2 nil
	)
	(foreach x lt
	  (if (not lt1)
	    (setq lt1 (list x))
	    (if	(equal zp (car x) 1e-4)
	      (setq lt1 (cons x lt1))
	      (progn (if (cadr lt1)
		       (setq lt2 (cons lt1 lt2))
		     )
		     (setq lt1 (list x))
	      )
	    )
	  )
	  (setq zp (+ (car x) (cadr x)))
	)
	(if (cadr lt1)
	  (setq lt2 (cons lt1 lt2))
	)
	(foreach x lt2
	  (setq	x   (reverse x)
		lt1 (car x)
		lt2 (last x)
		z1  (- (+ (car lt2) (cadr lt2)) (caar x))
		lt  (mapcar '(lambda (y) (nth 2 y)) x)
	  )
	  (getent (car lt))
	  (modent 39 z1)
	  (mapcar 'entdel (cdr lt))
	  (redraw (car lt))
	)
      )
    )
  )
  (princ)
)
(defun zmg_blk (wzq / pm st e1 lt lt1 lt2 z1 zp n i j info tf)
  (if (setq st (ssget (list (cons 8 (glayer wzq)) '(0 . "INSERT"))))
    (progn (prompt "\nغ߱Ƚ, Ҫϳʱ.  Ctrl+C ֹ.")
	   (setq n -1)
	   (while (setq	n  (1+ n)
			e1 (ssname st n)
		  )
	     (setq wzq	(entget e1)
		   info	(mapcar	'(lambda (x) (cdr (assoc x wzq)))
				'(10 2 41 42 50)
			)
		   pm	(car info)
		   z1	(caddr pm)
		   zp	(cdr (assoc 43 wzq))
		   pm	(list (car pm) (cadr pm))
		   info	(cons pm (cdr info))
		   j	(length lt)
		   tf	T
	     )
	     (while (and tf (>= (setq j (1- j)) 0))
	       (setq lt1 (nth j lt)
		     wzq (last (last lt1))
	       )
	       (if (< (abs (- (car pm) (caar wzq))) 2000.001)
		 (progn	(setq i -1)
			(while (and tf
				    (setq i   (1+ i)
					  lt2 (nth i lt1)
				    )
			       )
			  (setq wzq (last lt2))
			  (if (equal wzq info 1e-4)
			    (setq wzq (cons (list z1 zp e1) lt2)
				  wzq (subst wzq lt2 lt1)
				  tf  nil
			    )
			  )
			)
			(if tf
			  (setq	wzq (cons (list (list z1 zp e1) info) lt1)
				tf  nil
			  )
			)
			(setq lt (subst wzq lt1 lt))
		 )
	       )
	     )
	     (if tf
	       (setq lt (cons (list (list (list z1 zp e1) info)) lt))
	     )
	   )
	   (if (setq lt (apply 'append lt))
	     (prompt "\nȽ. ϲ...")
	   )
	   (foreach wzq	lt
	     (setq lt  (cdr (reverse wzq))
		   lt  (apply 'sort1 lt)
		   lt1 nil
		   lt2 nil
	     )
	     (foreach x	lt
	       (if (not lt1)
		 (setq lt1 (list x))
		 (if (equal zp (car x) 1e-4)
		   (setq lt1 (cons x lt1))
		   (progn (if (cadr lt1)
			    (setq lt2 (cons lt1 lt2))
			  )
			  (setq lt1 (list x))
		   )
		 )
	       )
	       (setq zp (+ (car x) (cadr x)))
	     )
	     (if (cadr lt1)
	       (setq lt2 (cons lt1 lt2))
	     )
	     (foreach x	lt2
	       (setq x	 (reverse x)
		     lt1 (car x)
		     lt2 (last x)
		     z1	 (- (+ (car lt2) (cadr lt2)) (caar x))
		     lt	 (mapcar '(lambda (y) (nth 2 y)) x)
	       )
	       (getent (car lt))
	       (modent 43 z1)
	       (mapcar 'entdel (cdr lt))
	       (redraw (car lt))
	     )
	   )
    )
  )
  (princ)
)
(defun c:local (/ ss p1 p2 ewx wzq)
  (setq wzq (ssget "p"))
  (setq ss (ssget "X" '((0 . "INSERT") (2 . "_WZQ"))))
  (if wzq
    (progn (setvar "highlight" 0)
	   (command ".select" wzq "")
	   (setvar "highlight" 1)
    )
  )
  (if (and ss
	   (setq p2 (xdout (setq ewx (ssname ss 0)) "LOCAL"))
	   (numberp (car p2))
      )
    (progn
      (initget "A R E")
      (setq wzq
	     (getkword
	       "\nоֲ༭δ/ A-ֲ/ R-ָԭͼ/ E-/ <˳>: "
	     )
      )
      (cond ((or (= wzq "A") (= wzq "R"))
	     (prompt (if (= wzq "A")
		       "\nԭͼѡҪֲ༭: "
		       "\nӾֲͼѡҪָԭͼλõ: "
		     )
	     )
	     (if (setq ss (ssget))
	       (command	".MOVE"
			ss
			""
			(trans (if (= wzq "A")
				 p2
				 (mapcar '- p2)
			       )
			       0
			       1
			       T
			)
			""
	       )
	     )
	    )
	    ((= wzq "E")
	     (initget "Y N")
	     (setq wzq
		    (getkword
		      "\nȷϸֲͼԪѻָλ, ༭(Y/N)? <N>: "
		    )
	     )
	     (if (= wzq "Y")
	       (progn (xdin "LOCAL" "") (prompt "\nֲ."))
	     )
	    )
      )
    )
    (progn
      (prompt "\nѡȡҪֲ༭: ")
      (if (setq ss (ssget))
	(progn
	  (setq p1 (getpoint "\nȡƶολ: "))
	  (if p1
	    (progn
	      (setq p2 (getpoint p1 "\nȡֲͼλ: "))
	      (setq p2 (if p2
			 (mapcar '- p2 p1)
			 p1
		       )
	      )
	      (command ".MOVE" ss "" p2 "")
	      (if (not ewx)
		(progn (command ".INSERT" "_WZQ" '(0 0 0) "" "" "")
		       (setq ewx (entlast))
		)
	      )
	      (apply 'xdin (cons ewx (cons "LOCAL" (trans p2 1 0 T))))
	    )
	  )
	)
      )
    )
  )
  (princ)
)