;--------------------------------
; This example script "RealisticExample.nsi" creates an installer for the example program
; GetFirstRemovableExample.exe (created using Example.nsi), which uses the "GetFirstRemovable.DLL" plug-in 
; to create a typical installer for a portable application. When the resulting installer is executed, it will 
; install "GetFirstRemovableExample.exe" as "MyApp" on the portable device.
;
; Support for the environment provided by "PortableApps.com" is included. If this environment is not detected,
; the installation program will support the creation of an AUTORUN.INF file for the application.
;
; This script also provides an example of how to use the multi-language capability of the MUI
;
;------------------------------------------------------------------------------
; RealisticExample.nsi  - Modern UI version
;------------------------------------------------------------------------------
; Script skeleton generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "MyApp Portable"
!define PRODUCT_VERSION "1.0"
!define PRODUCT_PUBLISHER "My Company, Inc"
!define PRODUCT_WEB_SITE "http://www.mycompany.com"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "License.txt"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY

Page custom AutoRun_Page

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\GetFirstRemovableExample.exe"
!insertmacro MUI_PAGE_FINISH

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Spanish"

; MUI end ------
;multi-lingual messages
LangString ErrIsRunning ${LANG_ENGLISH} "MyApp is still running. Please shut it down before re-installing."
LangString ErrIsRunning ${LANG_SPANISH} "MyApp est ejecutando. Por favor cerrarlo antes de re-instalar."
LangString ErrIsRunning ${LANG_FRENCH} "MyApp est toujours actif. Veuillez le fermer avant de rinstaller."

LangString ErrNoDrive ${LANG_ENGLISH} "Fatal Error: No removable drives found."
LangString ErrNoDrive ${LANG_SPANISH} "Error: No se encuentra ningun disco extraible."
LangString ErrNoDrive ${LANG_FRENCH} "Erreur fatale: aucune mmoire extractible trouve."

LangString AutoRunH1 ${LANG_ENGLISH} "Action to be taken when portable device is connected to computer"
LangString AutoRunH1 ${LANG_SPANISH} "Accin a hacer cuando se conecta el dispositivo al ordenador"
LangString AutoRunH1 ${LANG_FRENCH} "Action  prendre lorsqu'une mmoire extractible est connecte  l'ordinateur" 

LangString AutoRunH2 ${LANG_ENGLISH} "AUTORUN.INF Configuration"
LangString AutoRunH2 ${LANG_SPANISH} "AUTORUN.INF Configuracin"
LangString AutoRunH2 ${LANG_FRENCH} "AUTORUN.INF Configuration"

LangString AutoRunH3 ${LANG_ENGLISH} "The AUTORUN.INF file in the root directory can be modified so that MyApp will"
LangString AutoRunH3 ${LANG_SPANISH} "El fichero AUTORUN.INF puede ser modificado para permitir MyApp arranquer"
LangString AutoRunH3 ${LANG_FRENCH} "Le fichier AUTORUN.INF dans le rpertoire courant peut tre modifier pour que MyApp puisse "

LangString AutoRunH4 ${LANG_ENGLISH} "start when the device is connected to the computer. Please select your option below:"
LangString AutoRunH4 ${LANG_SPANISH} "cuando se inserta el dispositivo en el ordenador. Por favor selecciona su opcin:"
LangString AutoRunH4 ${LANG_FRENCH} "commencer lorsqu'une mmoire extractible est connecte  l'ordinateur. Veuillez choisir une option ci-bas:"

LangString AutoRunH5a ${LANG_ENGLISH} "Yes, create the AUTORUN.INF file"
LangString AutoRunH5a ${LANG_SPANISH} "S, crear el fichero AUTORUN.INF"
LangString AutoRunH5a ${LANG_FRENCH} "Oui, crer le fichier AUTORUN.INF."

LangString AutoRunH5b ${LANG_ENGLISH} "Yes, modify the AUTORUN.INF file"
LangString AutoRunH5b ${LANG_SPANISH} "S, modificar el fichero AUTORUN.INF"
LangString AutoRunH5b ${LANG_FRENCH} "Oui, modifier le fichier AUTORUN.INF"

LangString AutoRunH6a ${LANG_ENGLISH} "No, do not create the AUTORUN.INF file"
LangString AutoRunH6a ${LANG_SPANISH} "No, no crear el fichero AUTORUN.INF"
LangString AutoRunH6a ${LANG_FRENCH} "Non, ne pas crer le fichier AUTORUN.INF"

LangString AutoRunH6b ${LANG_ENGLISH} "No, do not modify the AUTORUN.INF file"
LangString AutoRunH6b ${LANG_SPANISH} "No, no modificar el fichero AUTORUN.INF"
LangString AutoRunH6b ${LANG_FRENCH} "Non, ne pas modifier le fichier AUTORUN.INF"

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "RealisticExampleInstall.exe"
InstallDir "\MyApp"
BrandingText "My Company, Inc"

AutoCloseWindow true
ShowInstDetails hide
ShowUnInstDetails hide

;------------------------------------------------------------------------------
;Reserve Files
  
  ;These files should be inserted before other files in the data block
  ;Keep these lines before any File command
  ;Only for solid compression (by default, solid compression is enabled for BZIP2 and LZMA)
  
	ReserveFile "AutoRun.ini"

	!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

;------------------------------------------------------------------------------
;Variables
	Var INST_AUTORUN ;;1/0 to create/replace AUTORUN.INF file
	Var IS_PORTABLEAPP ;; y/n device has \PortableApps directory
	
!define HD_SPACE_UNCOMPRESSED $1

;------------------------------------------------------------------------------
;Installer Functions

;------------------------------------------------------------------------------
Function .onInit

	;Extract InstallOptions INI files
	!insertmacro MUI_INSTALLOPTIONS_EXTRACT "AutoRun.ini"

	; check if  app is already running
	; the Processes.dll seems to work for win2k and XP
	Push $R0
	Processes::FindProcess "GetFirstRemovableExample.exe"
	StrCmp $R0 "1" 0 NotRunning
	MessageBox MB_OK $(ErrIsRunning)
	Abort

	NotRunning:
	Pop $R0

	CheckRemovable:
	; Get first removable drive found:
	GetFirstRemovable::GetFirst
	Pop $R1

	StrCmp $R1 "" 0 cont1
	MessageBox MB_ABORTRETRYIGNORE|MB_ICONSTOP \
		$(ErrNoDrive) \
		IDRETRY CheckRemovable \
		IDIGNORE cont1
	Abort

	cont1:
	;; check for PortableApps installation
	IfFileExists "$R1PortableApps\*" 0 noPortableApps
	StrCpy $IS_PORTABLEAPP "y"
	StrCpy $INSTDIR "$R1PortableApps\MyApp"
	Goto hasPortableApps
	noPortableApps:
	StrCpy $IS_PORTABLEAPP "n"
	StrCpy $INSTDIR "$R1MyApp"
	hasPortableApps:
;	The following can be expanded to allow the user to select a portable drive from a list or whatever....
;	GetFirstRemovable::GetAll
;	Pop $R0
;	MessageBox MB_OK "GetAll is '$R0', GetFirst is '$R1' and INSTDIR is '$INSTDIR'"

FunctionEnd  ; .onInit

;------------------------------------------------------------------------------
Section "MainSection" SEC01

	SetOutPath "$INSTDIR"
	SetOverwrite ifnewer
	File "GetFirstRemovableExample.exe" ; this is created by Example.nsi
	File "MyApp.ico"

SectionEnd

;------------------------------------------------------------------------------
Function AutoRun_Page

	StrCmp $IS_PORTABLEAPP "y" SkipAutoRunPage 0 ;; no autorun.inf if has PortableApps
	
	StrCpy $R0 $INSTDIR 2
	StrCpy $R1 "$R0\autorun.inf"
	;;MessageBox MB_OK $R1
	IfFileExists $R1 hasAutoRun 0
	StrCpy $R3 "1"
	StrCpy $R4 "0"
	StrCpy $R5 $(AutoRunH5a)
	StrCpy $R6 $(AutoRunH6a)
	Goto cont1
	hasAutoRun:
	StrCpy $R3 "0"
	StrCpy $R4 "1"
	StrCpy $R5 $(AutoRunH5b)
	StrCpy $R6 $(AutoRunH6b)
	cont1:
	StrCpy $R9 "AutoRun.ini"
	!insertmacro MUI_INSTALLOPTIONS_WRITE $R9 "Settings" "Title" $(AutoRunH2)
	!insertmacro MUI_INSTALLOPTIONS_WRITE $R9 "Field 1" "Text" $(AutoRunH3)
	!insertmacro MUI_INSTALLOPTIONS_WRITE $R9 "Field 2" "Text" $(AutoRunH4)
	!insertmacro MUI_INSTALLOPTIONS_WRITE $R9 "Field 4" "Text" $R5
	!insertmacro MUI_INSTALLOPTIONS_WRITE $R9 "Field 4" "State" $R3
	!insertmacro MUI_INSTALLOPTIONS_WRITE $R9 "Field 5" "Text" $R6
	!insertmacro MUI_INSTALLOPTIONS_WRITE $R9 "Field 5" "State" $R4
	!insertmacro MUI_HEADER_TEXT "$R1" $(AutoRunH1)
	!insertmacro MUI_INSTALLOPTIONS_DISPLAY $R9

	SkipAutoRunPage:
FunctionEnd
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
Section -Post

	;; AUTORUN.INF
	!insertmacro MUI_INSTALLOPTIONS_READ $INST_AUTORUN "AutoRun.ini" "Field 4" "State"
	StrCmp $INST_AUTORUN 1 0 SkipAutoRun
	;; create file in root dir
	StrCpy $R0 $INSTDIR 2
	Goto SkipAutoRun1
	SkipAutoRun:
	;; create file in installation dir
	StrCpy $R0 $INSTDIR
	SkipAutoRun1:
	StrCpy $R1 $INSTDIR 999 3
	WriteIniStr "$R0\autorun.inf" "autorun" "open" "$R1\GetFirstRemovableExample.exe"
	WriteIniStr "$R0\autorun.inf" "autorun" "icon" "$R1\MyApp.ico"
	WriteIniStr "$R0\autorun.inf" "autorun" "action" "Run MyApp"

SectionEnd

;------------------------------------------------------------------------------
