;-----------------------------------------------------------------------------------
; ExecTimeout
;-----------------------------------------------------------------------------------
;
; Usage:
;   ${ExecTimeout} <Commandline> <Timeout> <Terminate> <Var ExitCode>
;
; Arguments:
;   <Commandline> should contain the path to the executable file [string]
;   <Timeout> specifies the timeout in milliseconds [integer]
;   <Terminate> specifies whether the process will be terminated on timeout [0|1]
;
; Return Value:
;   <ExitCode> will return the exit code of the application, "timeout" or "error"
;
;-----------------------------------------------------------------------------------


;-----------------------------------------------------------------------------------
; Include
;-----------------------------------------------------------------------------------

!macro ExecTimeout commandline timeout_ms terminate var_exitcode
  Timeout::ExecTimeout '${commandline}' '${timeout_ms}' '${terminate}'
  Pop ${var_exitcode}
!macroend

!define ExecTimeout "!insertmacro ExecTimeout"


;-----------------------------------------------------------------------------------
; Example
;-----------------------------------------------------------------------------------

Name "TimeoutDemo"
OutFile "TimeoutDemo.exe"

ShowInstDetails show

Section
  InitPluginsDir
  File /oname=$PLUGINSDIR\myapp.exe "myapp.exe"
  
  MessageBox MB_ICONINFORMATION "I will start the application with ExecTimeout now. It will time out after 5 seconds!"
  DetailPrint 'Executing: "$PLUGINSDIR\myapp.exe"'
  ${ExecTimeout} '"$PLUGINSDIR\myapp.exe"' 5000 1 $0
  DetailPrint "Exit Code: $0"

  MessageBox MB_ICONINFORMATION "I will start the application with nsExec now. Timeout is set to 5 seconds, but..."
  DetailPrint 'Executing: "$PLUGINSDIR\myapp.exe"'
  nsExec::ExecToLog /TIMEOUT=5000 '"$PLUGINSDIR\myapp.exe"'
  Pop $0
  DetailPrint "Exit Code: $0"
SectionEnd
