/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.ui;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mactian.logic.pojo.Theme;
import org.mactian.ui.MainWindow;
import org.mactian.ui.ThemeBasicInfoPanel;
import org.mactian.ui.ThemeIconsPanel;
import org.mactian.ui.ThemePreviewPanel;
import org.mactian.ui.ThemeWallpaperPanel;

public class ThemeWorkspace {
    public static final int ACTION_CREATE = 1;
    public static final int ACTION_EDIT = 2;
    public static final int TAB_BASICINFO = 0;
    public static final int TAB_ICON = 1;
    public static final int TAB_WALLPAPER = 2;
    public static final int TAB_PREVIEW = 3;
    public static final int TAB_FONT = 4;
    private Theme theme;
    private final int action;
    private final MainWindow mainWindow;
    final JFrame jFrame;
    JTabbedPane tabbedPane;
    private JLabel statusFiled;
    private ThemeBasicInfoPanel basicInfoPanel;
    private ThemeIconsPanel iconsPanel;
    private ThemePreviewPanel previewPanel;
    private ThemeWallpaperPanel wallpaperPanel;

    public ThemeWorkspace(Theme theme, int action, MainWindow mainWindow) {
        this.theme = theme;
        this.action = action;
        this.mainWindow = mainWindow;
        this.jFrame = mainWindow.getFrame();
        this.initTabs();
        this.initTips();
    }

    private void initTabs() {
        this.tabbedPane = new JTabbedPane(2, 0);
        this.tabbedPane.setTabPlacement(1);
        this.tabbedPane.addTab("\u57fa\u672c\u4fe1\u606f", new ImageIcon(ThemeWorkspace.class.getResource("/ico/basicinfo.png")), null);
        this.tabbedPane.addTab("\u66f4\u6362\u56fe\u6807", new ImageIcon(ThemeWorkspace.class.getResource("/ico/icon.png")), null);
        this.tabbedPane.addTab("\u66f4\u6362\u58c1\u7eb8", new ImageIcon(ThemeWorkspace.class.getResource("/ico/wallpaper.png")), null);
        this.tabbedPane.addTab("\u4e3b\u9898\u9884\u89c8\u56fe", new ImageIcon(ThemeWorkspace.class.getResource("/ico/preview.png")), null);
        this.tabbedPane.addTab("\u66f4\u6362\u5b57\u4f53", new ImageIcon(ThemeWorkspace.class.getResource("/ico/font.png")), null);
        this.jFrame.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int n = ThemeWorkspace.this.tabbedPane.getSelectedIndex();
                if (ThemeWorkspace.this.tabbedPane.getSelectedComponent() == null) {
                    ThemeWorkspace.this.loadTabComponent(n);
                }
            }
        });
        this.loadTabComponent(0);
    }

    protected void loadTabComponent(int n) {
        try {
            if (n == 0) {
                if (this.basicInfoPanel == null) {
                    this.basicInfoPanel = new ThemeBasicInfoPanel(this);
                }
                this.tabbedPane.setComponentAt(n, this.basicInfoPanel);
            } else if (n == 1) {
                if (this.iconsPanel == null) {
                    this.iconsPanel = new ThemeIconsPanel(this.mainWindow);
                }
                this.tabbedPane.setComponentAt(n, this.iconsPanel);
            } else if (n == 2) {
                if (this.wallpaperPanel == null) {
                    this.wallpaperPanel = new ThemeWallpaperPanel(this.mainWindow);
                }
                this.tabbedPane.setComponentAt(n, this.wallpaperPanel);
            } else if (n == 3) {
                if (this.previewPanel == null) {
                    this.previewPanel = new ThemePreviewPanel(this.mainWindow);
                }
                this.tabbedPane.setComponentAt(n, this.previewPanel);
            } else {
                JOptionPane.showMessageDialog(this.jFrame, "TODO:\u6682\u4e0d\u652f\u6301\u6b64\u529f\u80fd.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void switchTab(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    private void initTips() {
        this.statusFiled = new JLabel(String.valueOf(this.action == 1 ? "[\u65b0\u5efa\u4e3b\u9898]" : "[\u7f16\u8f91\u4e3b\u9898]") + " \u8d44\u6e90\u76ee\u5f55:" + this.theme.getPath());
        this.jFrame.add((Component)this.statusFiled, "South");
    }

    private void repainUI() {
        this.jFrame.setVisible(true);
    }

    public void display() {
        this.repainUI();
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }
}

