/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mactian.handler.ThemeWallpaperHandler;
import org.mactian.logic.pojo.Theme;
import org.mactian.ui.MainWindow;
import org.mactian.ui.ThemeIconsPanel;
import org.mactian.ui.ThemeImageChooser;

public class ThemeWallpaperPanel
extends JPanel {
    private static final long serialVersionUID = -8742885093553636944L;
    MainWindow mainWindow;
    Theme theme;
    private String icon;
    ImageIcon defautWallpaperIcon;
    ThemeImageChooser fChooser;

    public ThemeWallpaperPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.theme = mainWindow.getTheme();
        this.defautWallpaperIcon = new ImageIcon(ThemeIconsPanel.class.getResource("/ico/select_image.png"));
        this.initThisUI();
    }

    private void initThisUI() {
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout(50, 50));
        this.fChooser = new ThemeImageChooser("\u8bbe\u7f6e\u684c\u9762\u58c1\u7eb8", "1280x960");
        ImageIcon imageIcon = null;
        imageIcon = this.icon == null || this.icon.length() == 0 ? this.defautWallpaperIcon : new ImageIcon(this.icon);
        final JLabel iconJLabel = new JLabel(imageIcon);
        iconJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int select = ThemeWallpaperPanel.this.fChooser.showOpenDialog(ThemeWallpaperPanel.this.mainWindow.getFrame());
                if (select == 0) {
                    String path = ThemeWallpaperPanel.this.fChooser.getSelectedFile().getAbsolutePath();
                    iconJLabel.setIcon(new ImageIcon(path));
                    try {
                        ThemeWallpaperHandler handler = new ThemeWallpaperHandler(ThemeWallpaperPanel.this.theme);
                        handler.replace(path);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.add((Component)iconJLabel, "Center");
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }
}

