/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mactian.handler.ThemePreviewHandler;
import org.mactian.logic.pojo.Theme;
import org.mactian.ui.MainWindow;
import org.mactian.ui.ThemeIconsPanel;
import org.mactian.ui.ThemeImageChooser;

public class ThemePreviewPanel
extends JPanel {
    private static final long serialVersionUID = -8742885093553636944L;
    MainWindow mainWindow;
    Theme theme;
    private String icon;
    ImageIcon defautPreviewIcon;
    ThemeImageChooser fChooser;

    public ThemePreviewPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.theme = mainWindow.getTheme();
        this.defautPreviewIcon = new ImageIcon(ThemeIconsPanel.class.getResource("/ico/select_image.png"));
        this.initThisUI();
    }

    private void initThisUI() {
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout(50, 50));
        this.fChooser = new ThemeImageChooser("\u4e0a\u4f20\u4e3b\u9898\u9884\u89c8\u56fe", "720x1280");
        ImageIcon imageIcon = null;
        imageIcon = this.icon == null || this.icon.length() == 0 ? this.defautPreviewIcon : new ImageIcon(this.icon);
        final JLabel iconJLabel = new JLabel(imageIcon);
        iconJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int select = ThemePreviewPanel.this.fChooser.showOpenDialog(ThemePreviewPanel.this.mainWindow.getFrame());
                if (select == 0) {
                    String path = ThemePreviewPanel.this.fChooser.getSelectedFile().getAbsolutePath();
                    iconJLabel.setIcon(new ImageIcon(path));
                    try {
                        ThemePreviewHandler handler = new ThemePreviewHandler(ThemePreviewPanel.this.theme);
                        handler.replace(path);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.add((Component)iconJLabel, "Center");
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }
}

