/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mactian.handler.ThemeIconHandler;
import org.mactian.logic.GlobalConfig;
import org.mactian.logic.pojo.Theme;
import org.mactian.logic.pojo.ThemeIcon;
import org.mactian.logic.pojo.ThemeIconType;
import org.mactian.logic.util.FileUtils;
import org.mactian.ui.MainWindow;
import org.mactian.ui.ThemeImageChooser;

public class ThemeIconsPanel
extends JPanel {
    private static final long serialVersionUID = 1641252322585939717L;
    MainWindow mainWindow;
    ThemeIcon[] iconTypes;
    JList menuList;
    ReplacementIconsPanel replacementIconsPanel;
    JScrollPane iconsPanel;
    JSplitPane contentPanel;
    ThemeImageChooser fChooser;
    List<ThemeIcon> defaultSystemIcons;
    List<ThemeIcon> defaultAppIcons;
    Theme theme;
    ThemeIconHandler themeIconHandler;

    public ThemeIconsPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.theme = mainWindow.getTheme();
        this.iconTypes = new ThemeIcon[]{new ThemeIcon(ThemeIconType.System, "\u7cfb\u7edf\u56fe\u6807", "/ico/icon_system.png"), new ThemeIcon(ThemeIconType.App, "\u5e94\u7528\u56fe\u6807", "/ico/icon_app.png")};
        this.defaultSystemIcons = GlobalConfig.get().getDefaultSystemIcons();
        this.defaultAppIcons = GlobalConfig.get().getDefaultAppIcons();
        this.initUI();
        this.setupListener();
        this.menuList.setSelectedIndex(0);
        this.themeIconHandler = new ThemeIconHandler(this.theme);
    }

    private void initUI() {
        this.fChooser = new ThemeImageChooser("\u66ff\u6362\u56fe\u6807", "110x110");
        this.menuList = new JList<ThemeIcon>(this.iconTypes);
        this.menuList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -2716568013832798764L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ThemeIcon) {
                    ThemeIcon icon = (ThemeIcon)value;
                    label.setText(icon.getName());
                    label.setIcon(new ImageIcon(ThemeIconsPanel.class.getResource(icon.getUrl())));
                }
                return label;
            }
        });
        this.replacementIconsPanel = new ReplacementIconsPanel();
        this.iconsPanel = new JScrollPane(this.replacementIconsPanel, 22, 31);
        this.contentPanel = new JSplitPane(1, this.menuList, this.iconsPanel);
        this.contentPanel.setBorder(null);
        this.contentPanel.setOneTouchExpandable(false);
        this.setBackground(Color.WHITE);
        this.setLayout(new FlowLayout(0));
        this.add((Component)this.contentPanel, "Center");
    }

    List<ThemeIcon> fetchThemeReplacedIcons(ThemeIconType type) {
        LinkedList<ThemeIcon> list = new LinkedList<ThemeIcon>();
        List<ThemeIcon> defaultList = null;
        Map<String, ThemeIcon> iconsMapping = this.theme.getIconsMapping();
        if (type == ThemeIconType.System) {
            defaultList = this.defaultSystemIcons;
        } else if (type == ThemeIconType.App) {
            defaultList = this.defaultAppIcons;
        }
        if (defaultList != null) {
            for (ThemeIcon ti : defaultList) {
                ThemeIcon icon = iconsMapping.get(ti.getId());
                if (icon == null || !FileUtils.exists(icon.getUrl())) {
                    icon = ti;
                }
                list.add(icon);
            }
        }
        return list;
    }

    private void setupListener() {
        this.menuList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ThemeIcon icon = (ThemeIcon)ThemeIconsPanel.this.menuList.getSelectedValue();
                ThemeIconType type = icon.getType();
                if (type == ThemeIconType.System) {
                    ThemeIconsPanel.this.replacementIconsPanel.setIcons(ThemeIconsPanel.this.fetchThemeReplacedIcons(ThemeIconType.System));
                    ThemeIconsPanel.this.replacementIconsPanel.show();
                } else if (type == ThemeIconType.App) {
                    ThemeIconsPanel.this.replacementIconsPanel.setIcons(ThemeIconsPanel.this.fetchThemeReplacedIcons(ThemeIconType.App));
                    ThemeIconsPanel.this.replacementIconsPanel.show();
                }
            }
        });
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    static BufferedImage resize(String path, int width, int height) throws IOException {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(path));
        }
        catch (IOException e) {
            try {
                image = ImageIO.read(ThemeIconsPanel.class.getResource(path));
            }
            catch (IOException e1) {
                image = null;
            }
        }
        if (image == null) {
            throw new IOException("\u83b7\u53d6\u56fe\u6807\u5931\u8d25");
        }
        BufferedImage bi = new BufferedImage(width, height, 3);
        Graphics2D g2d = bi.createGraphics();
        g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2d.drawImage(image, 0, 0, width, height, null);
        g2d.dispose();
        return bi;
    }

    class ReplacementIconsPanel
    extends JPanel {
        private static final long serialVersionUID = -6073579795853317353L;
        List<ThemeIcon> icons;

        public ReplacementIconsPanel() {
            this.initThisUI();
        }

        public ReplacementIconsPanel(List<ThemeIcon> icons) {
            this.icons = icons;
            this.initThisUI();
        }

        private void initThisUI() {
            this.setBackground(Color.WHITE);
            this.setLayout(new GridLayout(0, 8, 3, 2));
        }

        public List<ThemeIcon> getIcons() {
            return this.icons;
        }

        public void setIcons(List<ThemeIcon> icons) {
            this.icons = icons;
        }

        @Override
        public void show() {
            if (this.icons == null || this.icons.isEmpty()) {
                return;
            }
            this.removeAll();
            int size = this.icons.size();
            int rows = size % 8 == 0 ? size / 8 : size / 8 + 1;
            this.setPreferredSize(new Dimension(900, 90 * rows + (rows - 1) * 2));
            int i = 0;
            while (i < size) {
                block4: {
                    final ThemeIcon icon = this.icons.get(i);
                    BufferedImage image = null;
                    try {
                        image = ThemeIconsPanel.resize(icon.getUrl(), 72, 72);
                    }
                    catch (IOException e2) {
                        System.err.println("icon missed: " + icon.getUrl());
                        break block4;
                    }
                    ImageIcon imageIcon = new ImageIcon(image);
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BorderLayout(0, 0));
                    final JLabel iconJLabel = new JLabel(imageIcon);
                    iconJLabel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            int select = ((ReplacementIconsPanel)ReplacementIconsPanel.this).ThemeIconsPanel.this.fChooser.showOpenDialog(((ReplacementIconsPanel)ReplacementIconsPanel.this).ThemeIconsPanel.this.mainWindow.getFrame());
                            if (select == 0) {
                                String path = ((ReplacementIconsPanel)ReplacementIconsPanel.this).ThemeIconsPanel.this.fChooser.getSelectedFile().getAbsolutePath();
                                iconJLabel.setIcon(new ImageIcon(path));
                                try {
                                    ((ReplacementIconsPanel)ReplacementIconsPanel.this).ThemeIconsPanel.this.themeIconHandler.replace(icon, path);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    jPanel.add((Component)iconJLabel, "North");
                    JLabel tipLabel = new JLabel(icon.getName());
                    tipLabel.setHorizontalAlignment(0);
                    tipLabel.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 12));
                    jPanel.add((Component)tipLabel, "South");
                    jPanel.setBackground(Color.WHITE);
                    this.add(jPanel);
                }
                ++i;
            }
            this.updateUI();
        }
    }
}

