/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.mactian.logic.pojo.Theme;
import org.mactian.logic.util.ThemeApkBuilder;
import org.mactian.ui.MainWindow;

public class ThemeBuildDialog
extends JFrame {
    private static final long serialVersionUID = -589957990783851624L;
    final Theme theme;
    private final JFrame jframe;
    JProgressBar progressBar;
    JTextArea logs;
    private JLabel status;
    Task task;

    public ThemeBuildDialog(MainWindow mainWindow) {
        this.theme = mainWindow.getTheme();
        this.jframe = mainWindow.getFrame();
        this.initialize();
    }

    private void initialize() {
        this.setSize(500, 250);
        this.setResizable(false);
        this.setTitle("\u7f16\u8bd1\u4e3b\u9898APK");
        this.setAlwaysOnTop(true);
        this.setLayout(new BorderLayout());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MainWindow.class.getResource("/ico/logo.png")));
        this.setDefaultCloseOperation(2);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setSize(500, 10);
        this.progressBar.setValue(0);
        this.progressBar.setVisible(true);
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "North");
        this.logs = new JTextArea();
        this.logs.setBackground(Color.WHITE);
        this.logs.setEditable(false);
        this.logs.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane scroll = new JScrollPane(this.logs);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setVerticalScrollBarPolicy(22);
        this.add((Component)scroll, "Center");
        this.status = new JLabel("\u4e3b\u9898APK\u4fdd\u5b58\u81f3: " + this.theme.getPath() + "\\" + this.theme.getName() + ".apk");
        this.add((Component)this.status, "South");
    }

    public void display() {
        this.setLocationRelativeTo(this.jframe);
        this.setVisible(true);
        this.task = new Task();
        this.task.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("progress" == evt.getPropertyName()) {
                    int progress = ThemeBuildDialog.this.task.getProgress();
                    ThemeBuildDialog.this.progressBar.setValue(progress);
                }
            }
        });
        this.task.execute();
    }

    class ProgressController
    extends Thread {
        Task t;
        int start;
        int end;

        public ProgressController(Task t, int start, int end) {
            this.t = t;
            this.start = start;
            this.end = end;
        }

        @Override
        public void run() {
            while (this.start < this.end) {
                Random random = new Random();
                this.start += random.nextInt(5);
                try {
                    Thread.sleep(random.nextInt(this.start > 50 ? 50 : 150));
                }
                catch (InterruptedException e) {
                    break;
                }
                this.t.updateProgress(this.start);
            }
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        private final ThemeApkBuilder.ThemeApkBuildListener listener;
        ProgressController progressController;

        public Task() {
            this.listener = new ThemeApkBuildListenerImpl(this);
            this.progressController = new ProgressController(this, 0, 50);
        }

        @Override
        public Void doInBackground() {
            ThemeBuildDialog.this.logs.append("\u7f16\u8bd1\u4e3b\u9898APK\u5f00\u59cb!\n");
            this.progressController.start();
            ThemeApkBuilder builder = new ThemeApkBuilder(ThemeBuildDialog.this.theme);
            builder.excute(this.listener);
            return null;
        }

        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            ThemeBuildDialog.this.logs.append("\u7f16\u8bd1\u4e3b\u9898APK\u7ed3\u675f!");
        }

        public void updateProgress(int progress) {
            this.setProgress(Math.min(progress, 100));
        }

        public ProgressController getProgressController() {
            return this.progressController;
        }
    }

    class ThemeApkBuildListenerImpl
    implements ThemeApkBuilder.ThemeApkBuildListener {
        Task t;
        ProgressController controller;

        public ThemeApkBuildListenerImpl(Task t) {
            this.t = t;
            this.controller = t.getProgressController();
        }

        @Override
        public void log(String log) {
            ThemeBuildDialog.this.logs.append(String.valueOf(log) + "\n");
        }

        @Override
        public void progress(int step) {
            int cur;
            if (this.controller != null) {
                this.controller.interrupt();
                this.controller = null;
            }
            int n = cur = step == 1 ? 40 : 40 + (step - 1) * 20;
            if (step == 4) {
                this.t.updateProgress(100);
                return;
            }
            int start = Math.max(cur, this.t.getProgress());
            int end = start + 20;
            this.controller = new ProgressController(this.t, start, end);
            this.controller.start();
        }
    }
}

