/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.mactian.handler.ThemeWorkspaceHandler;
import org.mactian.logic.GlobalConfig;
import org.mactian.logic.pojo.Theme;
import org.mactian.ui.MainWindow;
import org.mactian.ui.ThemeWorkspace;

public class ThemeBasicInfoPanel
extends JPanel {
    private static final long serialVersionUID = 6280699737648947146L;
    JTextField pathField;
    JTextField nameField;
    JTextField authorField;
    JTextField aliasField;
    JButton saveButton;
    ThemeWorkspace workspace;
    MainWindow mainWindow;
    Theme theme;
    Pattern ThemePackageNamePattern = Pattern.compile("[A-Za-z]+\\w*");

    public ThemeBasicInfoPanel(ThemeWorkspace workspace) {
        this.workspace = workspace;
        this.mainWindow = workspace.getMainWindow();
        this.theme = this.mainWindow.getTheme();
        this.initUI();
        this.setupListener();
    }

    private void initUI() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridLayout(0, 1, 5, 5));
        contentPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel("\u4e3b\u9898\u5305\u57fa\u672c\u4fe1\u606f");
        titlePanel.setBackground(Color.LIGHT_GRAY);
        titlePanel.setBorder(new EmptyBorder(5, 10, 5, 0));
        titlePanel.add(titleLabel);
        JPanel pathPanel = new JPanel();
        JLabel pathLabel = new JLabel("\u8d44\u6e90\u76ee\u5f55");
        this.pathField = new JTextField(30);
        this.pathField.setText(this.theme.getPath());
        this.pathField.setEditable(false);
        pathPanel.add(pathLabel);
        pathPanel.add(this.pathField);
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(30);
        this.nameField.setText(this.theme.getName());
        this.nameField.requestFocus();
        JLabel nameLabel = new JLabel("\u82f1\u6587\u540d\u79f0");
        nameLabel.setLabelFor(this.nameField);
        namePanel.add(nameLabel);
        namePanel.add(this.nameField);
        JPanel aliasPanel = new JPanel();
        this.aliasField = new JTextField(30);
        JLabel aliasLabel = new JLabel("\u4e2d\u6587\u540d\u79f0");
        aliasLabel.setLabelFor(this.aliasField);
        aliasPanel.add(aliasLabel);
        aliasPanel.add(this.aliasField);
        JPanel authorPanel = new JPanel();
        this.authorField = new JTextField(30);
        this.authorField.setText(this.theme.getAuthor());
        JLabel authorLabel = new JLabel("\u4e3b\u9898\u4f5c\u8005");
        authorLabel.setLabelFor(this.authorField);
        authorPanel.add(authorLabel);
        authorPanel.add(this.authorField);
        JPanel savePanel = new JPanel();
        this.saveButton = new JButton("\u4fdd\u5b58\u4e3b\u9898\u4fe1\u606f");
        savePanel.add(this.saveButton);
        contentPanel.add(titlePanel);
        contentPanel.add(pathPanel);
        contentPanel.add(namePanel);
        contentPanel.add(aliasPanel);
        contentPanel.add(authorPanel);
        contentPanel.add(savePanel);
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.add((Component)contentPanel, gbc);
    }

    private void setupListener() {
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeBasicInfoPanel.this.blockingAction(true);
                if (this.validateValues()) {
                    ThemeWorkspaceHandler handler = new ThemeWorkspaceHandler(ThemeBasicInfoPanel.this.theme);
                    try {
                        handler.create();
                        Thread.sleep(1000L);
                        ThemeBasicInfoPanel.this.mainWindow.enableSaveItem(true);
                        ThemeBasicInfoPanel.this.mainWindow.enableBuildItem(true);
                        ThemeBasicInfoPanel.this.workspace.switchTab(1);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        ThemeBasicInfoPanel.this.showDialog(GlobalConfig.get().getErrorMsg("001"), 0);
                    }
                }
                ThemeBasicInfoPanel.this.blockingAction(false);
            }

            private boolean validateValues() {
                JTextField[] fields;
                JTextField[] jTextFieldArray = fields = new JTextField[]{ThemeBasicInfoPanel.this.nameField, ThemeBasicInfoPanel.this.aliasField, ThemeBasicInfoPanel.this.authorField};
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    JTextField field = jTextFieldArray[n2];
                    String value = field.getText();
                    if (value == null || value.trim().length() == 0) {
                        field.setBorder(BorderFactory.createLineBorder(Color.RED));
                        field.requestFocus();
                        return false;
                    }
                    ++n2;
                }
                ThemeBasicInfoPanel.this.theme.setAuthor(ThemeBasicInfoPanel.this.authorField.getText().trim());
                ThemeBasicInfoPanel.this.theme.setAlias(ThemeBasicInfoPanel.this.aliasField.getText().trim());
                String name = ThemeBasicInfoPanel.this.nameField.getText().trim();
                if (!ThemeBasicInfoPanel.this.ThemePackageNamePattern.matcher(name).matches()) {
                    ThemeBasicInfoPanel.this.nameField.setBorder(BorderFactory.createLineBorder(Color.RED));
                    ThemeBasicInfoPanel.this.nameField.requestFocus();
                    ThemeBasicInfoPanel.this.showDialog(GlobalConfig.get().getErrorMsg("002"), 0);
                    return false;
                }
                ThemeBasicInfoPanel.this.theme.setName(name);
                return true;
            }
        });
    }

    void blockingAction(boolean flag) {
        if (flag) {
            this.saveButton.setEnabled(false);
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(null);
            this.saveButton.setEnabled(true);
        }
    }

    void showDialog(String msg, int type) {
        JOptionPane.showMessageDialog(this, msg, "\u63d0\u793a", type);
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }
}

