/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.ui;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.mactian.logic.pojo.Theme;
import org.mactian.ui.ThemeBuildDialog;
import org.mactian.ui.ThemeWorkspace;
import org.mactian.ui.ThemeWorkspaceChooser;

public class MainWindow {
    private JFrame frame;
    private static MainWindow mainWindow;
    Theme theme;
    JMenuItem saveItem;
    JMenuItem buildItem;
    static final String Tutorials_URL = "http://bbs.dakele.com/thread-67069-1-1.html";

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainWindow window = MainWindow.getInstance();
                    window.getFrame().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private MainWindow() {
        this.initialize();
    }

    private void initialize() {
        this.frame = new JFrame();
        this.frame.setSize(1024, 680);
        double width = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double height = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        this.frame.setLocation((int)(width - (double)this.frame.getWidth()) / 2, (int)(height - (double)this.frame.getHeight()) / 2);
        this.frame.setResizable(false);
        this.frame.setTitle("\u5927\u53ef\u4e50\u624b\u673a\u4e3b\u9898\u7f16\u8f91\u5668");
        this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(MainWindow.class.getResource("/ico/logo.png")));
        this.frame.setDefaultCloseOperation(3);
        this.loadMenus();
        try {
            UIManager.setLookAndFeel("com.jgoodies.looks.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.theme = new Theme();
    }

    private void loadMenus() {
        JMenuBar mbar = new JMenuBar();
        JMenu file = new JMenu("\u6587\u4ef6");
        JMenuItem newItem = new JMenuItem("\u65b0\u5efa", new ImageIcon(MainWindow.class.getResource("/ico/new.png")));
        newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ThemeWorkspaceChooser(MainWindow.getInstance()).create();
            }
        });
        JMenuItem viewItem = new JMenuItem("\u6253\u5f00");
        viewItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        viewItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        viewItem.setEnabled(false);
        this.saveItem = new JMenuItem("\u4fdd\u5b58");
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.enableSaveItem(false);
        this.buildItem = new JMenuItem("\u6253\u5305");
        this.buildItem.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.buildItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeBuildDialog buildDialog = new ThemeBuildDialog(MainWindow.getInstance());
                buildDialog.display();
            }
        });
        this.enableBuildItem(false);
        JMenuItem exitItem = new JMenuItem("\u9000\u51fa", new ImageIcon(MainWindow.class.getResource("/ico/exit.png")));
        exitItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.getFrame().dispose();
                System.exit(0);
            }
        });
        file.add(newItem);
        file.add(this.saveItem);
        file.add(this.buildItem);
        file.addSeparator();
        file.add(exitItem);
        JMenu help = new JMenu("\u5e2e\u52a9");
        JMenuItem aboutItem = new JMenuItem("\u5173\u4e8e", new ImageIcon(MainWindow.class.getResource("/ico/about.png")));
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(MainWindow.this.getFrame(), "\u5927\u53ef\u4e50\u624b\u673a\u4e3b\u9898\u7f16\u8f91\u5668\n\u7248\u672c:V1.1.10", "\u5173\u4e8e", 1);
            }
        });
        help.add(aboutItem);
        String tutor = "\u6559\u7a0b";
        JMenuItem tutorItem = new JMenuItem(tutor);
        tutorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI(MainWindow.Tutorials_URL));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        });
        help.add(tutorItem);
        mbar.add(file);
        mbar.add(help);
        this.frame.setJMenuBar(mbar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MainWindow getInstance() {
        Class<MainWindow> clazz = MainWindow.class;
        synchronized (MainWindow.class) {
            if (mainWindow == null) {
                mainWindow = new MainWindow();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mainWindow;
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void initCreateWorkSpace(String path) {
        this.theme.setPath(path);
        new ThemeWorkspace(this.theme, 1, mainWindow).display();
    }

    public void initEditeWorkSpace(String path) {
        this.theme.setPath(path);
        new ThemeWorkspace(this.theme, 2, mainWindow).display();
    }

    public void enableSaveItem(boolean enable) {
        this.saveItem.setEnabled(enable);
    }

    public void enableBuildItem(boolean enable) {
        this.buildItem.setEnabled(enable);
    }
}

