/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.logic.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mactian.logic.pojo.Theme;

public class ThemeApkBuilder
extends Thread {
    private final Theme theme;

    public ThemeApkBuilder(Theme theme) {
        this.theme = theme;
    }

    public void excute(ThemeApkBuildListener listener) {
        String appPath = this.getAppPath();
        String binPath = String.valueOf(appPath) + "win_theme_pack_tool";
        String bin = String.valueOf(binPath) + "/genThemeApk.bat";
        String themePath = this.theme.getPath();
        StringBuilder cmd = new StringBuilder();
        cmd.append(bin).append(" ");
        cmd.append(binPath).append(" ");
        cmd.append(themePath).append(" ");
        cmd.append(this.theme.getName());
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd.toString());
            ThemeApkBuildTracer errorTracer = new ThemeApkBuildTracer(p.getErrorStream(), listener);
            ThemeApkBuildTracer outputTracer = new ThemeApkBuildTracer(p.getInputStream(), listener);
            errorTracer.start();
            outputTracer.start();
            p.waitFor();
            p.destroy();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private String getAppPath() {
        return System.getProperty("appdir");
    }

    public static interface ThemeApkBuildListener {
        public void log(String var1);

        public void progress(int var1);
    }

    class ThemeApkBuildTracer
    extends Thread {
        InputStream is;
        ThemeApkBuildListener listener;
        final Pattern StepFinishPattern = Pattern.compile("^step(1|2|3|4) finished\\.$");

        public ThemeApkBuildTracer(InputStream is, ThemeApkBuildListener listener) {
            this.is = is;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    Matcher matcher = this.StepFinishPattern.matcher(line);
                    if (matcher.matches()) {
                        this.listener.progress(Integer.parseInt(matcher.group(1)));
                        continue;
                    }
                    this.listener.log(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

