/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.logic.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    public static boolean copy(String oldname, String newname, boolean overwrite) throws IOException {
        int len;
        if (!overwrite && new File(newname).exists()) {
            return false;
        }
        FileInputStream input = new FileInputStream(oldname);
        String newDire = newname.substring(0, newname.lastIndexOf("/"));
        FileUtils.mkdirs(newDire);
        FileOutputStream output = new FileOutputStream(newname);
        byte[] b = new byte[5120];
        while ((len = input.read(b)) != -1) {
            output.write(b, 0, len);
        }
        output.flush();
        output.close();
        input.close();
        return true;
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            String[] stringArray = files = src.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                FileUtils.copyFolder(srcFile, destFile);
                ++n2;
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static boolean deleteFile(String FileName) {
        File filename;
        boolean bRet = false;
        if (FileName != null && FileName.length() > 0 && (filename = new File(FileName)).delete()) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean deleteTree(String PathName) {
        File path = new File(PathName);
        String[] list = path.list();
        boolean isok = true;
        if (list != null) {
            int length = list.length;
            int x = 0;
            while (x < length) {
                String temp = String.valueOf(PathName) + "/" + list[x];
                File f = new File(temp);
                if (f.isFile()) {
                    isok = f.delete();
                } else {
                    if (f.isDirectory()) {
                        isok = FileUtils.isEmptyDir(f) ? f.delete() : FileUtils.deleteTree(temp);
                    }
                    if (!isok) {
                        return false;
                    }
                }
                ++x;
            }
            path.delete();
        }
        return isok;
    }

    private static boolean isEmptyDir(File tempdir) {
        if (tempdir.exists() && tempdir.isDirectory()) {
            String[] list = tempdir.list();
            return list.length == 0;
        }
        return true;
    }

    public static String getFileName(String filePath) {
        File file = new File(filePath);
        return file.getName();
    }

    public static String getFilePath(String fileName) {
        File file = new File(fileName);
        return file.getAbsolutePath();
    }

    public static String getTypePart(String fileName) {
        int point = fileName.lastIndexOf(46);
        int length = fileName.length();
        if (point == -1 || point == length - 1) {
            return "";
        }
        return fileName.substring(point + 1, length);
    }

    public static String getFileType(File file) {
        return FileUtils.getTypePart(file.getName());
    }

    public static boolean canRead(String remoteAbsPath) throws Exception {
        return FileUtils.getFile(remoteAbsPath).canRead();
    }

    public static boolean canWrite(String remoteAbsPath) throws Exception {
        return FileUtils.getFile(remoteAbsPath).canWrite();
    }

    public static void deleteOnExit(String remoteAbsPath) throws Exception {
        FileUtils.getFile(remoteAbsPath).deleteOnExit();
    }

    public static boolean exists(String remoteAbsPath) {
        return FileUtils.getFile(remoteAbsPath).exists();
    }

    public static String getCanonicalPath(String remoteAbsPath) throws Exception, IOException {
        return FileUtils.getFile(remoteAbsPath).getCanonicalPath();
    }

    private static File getFile(String remoteAbsPath) {
        return new File(remoteAbsPath);
    }

    public static String getServerWorkDir() throws IOException, Exception {
        return FileUtils.getFile(".").getCanonicalPath();
    }

    public static boolean isDirectory(String remoteAbsPath) throws Exception {
        return FileUtils.getFile(remoteAbsPath).isDirectory();
    }

    public static boolean isFile(String remoteAbsPath) throws Exception {
        return FileUtils.getFile(remoteAbsPath).isFile();
    }

    public static boolean isHidden(String remoteAbsPath) throws Exception {
        return FileUtils.getFile(remoteAbsPath).isHidden();
    }

    public static long lastModified(String remoteAbsPath) throws Exception {
        return FileUtils.getFile(remoteAbsPath).lastModified();
    }

    public static long length(String remoteAbsPath) {
        return FileUtils.getFile(remoteAbsPath).length();
    }

    public static String[] list(String remoteAbsPath) {
        return FileUtils.getFile(remoteAbsPath).list();
    }

    public static boolean mkdir(String remoteAbsPath) {
        return FileUtils.getFile(remoteAbsPath).mkdir();
    }

    public static boolean mkdirs(String remoteAbsPath) {
        return FileUtils.getFile(remoteAbsPath).mkdirs();
    }

    public static boolean renameTo(String origRemoteAbsPath, String renamedRemoteAbsPath) throws Exception {
        return FileUtils.getFile(origRemoteAbsPath).renameTo(FileUtils.getFile(renamedRemoteAbsPath));
    }

    public static boolean setReadOnly(String remoteAbsPath) {
        return FileUtils.getFile(remoteAbsPath).setReadOnly();
    }

    public static boolean write(String file, InputStream input) throws Exception {
        int len;
        FileOutputStream output = new FileOutputStream(file);
        byte[] b = new byte[5120];
        while ((len = input.read(b)) != -1) {
            output.write(b, 0, len);
        }
        output.flush();
        output.close();
        input.close();
        return true;
    }
}

