/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.logic;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.mactian.logic.pojo.ThemeIcon;
import org.mactian.logic.pojo.ThemeIconType;

public class GlobalConfig {
    private static GlobalConfig instance;
    private final List<ThemeIcon> defaultSystemIcons = new LinkedList<ThemeIcon>();
    private final List<ThemeIcon> defaultAppIcons = new LinkedList<ThemeIcon>();
    private Properties errorDefine;
    public static final String ANDROID_RES_BASE_PATH = "/res";
    public static final String ANDROID_RES_XML_PATH = "/res/xml";
    public static final String ANDROID_RES_DRAWS_PATH = "/res/drawable-xhdpi";
    public static final String ANDROID_RES_VALUES_PATH = "/res/values";
    public static final String ANDROID_RES_VALUES_CN_PATH = "/res/values-zh-rCN";
    public static final String CREATE_INIT_ERROR = "001";
    public static final String THEME_PACKAGE_NAME_INVALID = "002";

    private GlobalConfig() {
        this.init();
    }

    private void init() {
        Document document = null;
        try {
            ThemeIcon icon;
            String iconId;
            SAXReader reader = new SAXReader();
            document = reader.read(GlobalConfig.class.getResourceAsStream("/config/theme_schema.xml"));
            List list = document.selectNodes("//icons[@type='app']/icon");
            for (Element iconElement : list) {
                iconId = iconElement.attributeValue("id");
                icon = new ThemeIcon(iconId, iconElement.attributeValue("name"), ThemeIconType.App, "/res/drawable-xhdpi/" + iconId + ".png", iconElement.attributeValue("ref"));
                this.defaultAppIcons.add(icon);
            }
            list = document.selectNodes("//icons[@type='system']/icon");
            for (Element iconElement : list) {
                iconId = iconElement.attributeValue("id");
                icon = new ThemeIcon(iconId, iconElement.attributeValue("name"), ThemeIconType.System, "/res/drawable-xhdpi/" + iconId + ".png", iconElement.attributeValue("ref"));
                this.defaultSystemIcons.add(icon);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.errorDefine = new Properties();
            this.errorDefine.load(GlobalConfig.class.getResourceAsStream("/config/error_define.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalConfig get() {
        Class<GlobalConfig> clazz = GlobalConfig.class;
        synchronized (GlobalConfig.class) {
            if (instance == null) {
                instance = new GlobalConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<ThemeIcon> getDefaultSystemIcons() {
        return this.defaultSystemIcons;
    }

    public List<ThemeIcon> getDefaultAppIcons() {
        return this.defaultAppIcons;
    }

    public Properties getErrorDefine() {
        return this.errorDefine;
    }

    public String getErrorMsg(String code) {
        String msg = this.errorDefine.getProperty(code);
        try {
            return new String(msg.getBytes("ISO-8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }
}

