/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.mactian.logic.GlobalConfig;
import org.mactian.logic.pojo.Theme;
import org.mactian.logic.pojo.ThemeIcon;
import org.mactian.logic.util.FileUtils;

public class ThemeWorkspaceHandler {
    private Theme theme;

    public ThemeWorkspaceHandler(Theme theme) {
        this.theme = theme;
    }

    public void create() throws Exception {
        if (this.theme.getCreateTime() == null) {
            this.initResourceDirectory();
        } else {
            this.theme.setModifyTime(new Date());
        }
        this.activeBasicInformation();
        this.persistence();
    }

    private void initResourceDirectory() throws Exception {
        String defaultIcon;
        String basePath = this.theme.getPath();
        String xmlPath = String.valueOf(basePath) + "/res/xml";
        String valuePath = String.valueOf(basePath) + "/res/values";
        String valueCNPath = String.valueOf(basePath) + "/res/values-zh-rCN";
        FileUtils.mkdirs(String.valueOf(basePath) + "/res/drawable-xhdpi");
        FileUtils.mkdirs(valuePath);
        FileUtils.mkdirs(valueCNPath);
        FileUtils.mkdirs(xmlPath);
        String manifestxml = String.valueOf(basePath) + "/AndroidManifest.xml";
        String stringsxml = String.valueOf(valuePath) + "/strings.xml";
        String stringsCNxml = String.valueOf(valueCNPath) + "/strings.xml";
        FileUtils.write(manifestxml, this.getClass().getResourceAsStream("/AndroidManifest.xml"));
        FileUtils.write(String.valueOf(xmlPath) + "/android.xml", this.getClass().getResourceAsStream("/res/xml/android.xml"));
        FileUtils.write(String.valueOf(valuePath) + "/themes.xml", this.getClass().getResourceAsStream("/res/values/themes.xml"));
        FileUtils.write(stringsxml, this.getClass().getResourceAsStream("/res/values/strings.xml"));
        FileUtils.write(stringsCNxml, this.getClass().getResourceAsStream("/res/values-zh-rCN/strings.xml"));
        List<ThemeIcon> iconList = GlobalConfig.get().getDefaultAppIcons();
        for (ThemeIcon icon : iconList) {
            System.out.println(String.valueOf(icon.getId()) + ":" + icon.getUrl());
            defaultIcon = String.valueOf(basePath) + "/res/drawable-xhdpi" + "/" + icon.getId() + ".png";
            if (!FileUtils.write(defaultIcon, this.getClass().getResourceAsStream("/res/drawable-xhdpi/" + icon.getId() + ".png"))) continue;
            FileUtils.write(String.valueOf(xmlPath) + "/" + icon.getRef(), this.getClass().getResourceAsStream("/res/xml/" + icon.getRef()));
        }
        iconList = GlobalConfig.get().getDefaultSystemIcons();
        for (ThemeIcon icon : iconList) {
            defaultIcon = String.valueOf(basePath) + "/res/drawable-xhdpi" + "/" + icon.getId() + ".png";
            if (!FileUtils.write(defaultIcon, this.getClass().getResourceAsStream("/res/drawable-xhdpi/" + icon.getId() + ".png"))) continue;
            FileUtils.write(String.valueOf(xmlPath) + "/" + icon.getRef(), this.getClass().getResourceAsStream("/res/xml/" + icon.getRef()));
        }
        FileUtils.write(String.valueOf(basePath) + "/res/drawable-xhdpi" + "/preview.png", this.getClass().getResourceAsStream("/res/drawable-xhdpi/preview.png"));
        FileUtils.write(String.valueOf(basePath) + "/res/drawable-xhdpi" + "/wallpaper.png", this.getClass().getResourceAsStream("/res/drawable-xhdpi/wallpaper.png"));
        this.theme.setCreateTime(new Date());
    }

    private void activeBasicInformation() {
        XMLWriter writer;
        FileOutputStream fos;
        OutputFormat format;
        Document document;
        SAXReader reader;
        String basePath = this.theme.getPath();
        String valuePath = String.valueOf(basePath) + "/res/values";
        String valueCNPath = String.valueOf(basePath) + "/res/values-zh-rCN";
        String manifestxml = String.valueOf(basePath) + "/AndroidManifest.xml";
        String stringsxml = String.valueOf(valuePath) + "/strings.xml";
        String stringsCNxml = String.valueOf(valueCNPath) + "/strings.xml";
        try {
            reader = new SAXReader();
            document = reader.read(new File(stringsxml));
            ((Element)document.selectSingleNode("//string[@name='app_name']")).setText(this.theme.getName());
            ((Element)document.selectSingleNode("//string[@name='theme_name']")).setText(this.theme.getName());
            ((Element)document.selectSingleNode("//string[@name='style_appearance_name']")).setText(this.theme.getName());
            ((Element)document.selectSingleNode("//string[@name='author']")).setText(this.theme.getAuthor());
            format = OutputFormat.createPrettyPrint();
            fos = new FileOutputStream(stringsxml);
            writer = new XMLWriter(fos, format);
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            reader = new SAXReader();
            document = reader.read(new File(manifestxml));
            ((Attribute)document.selectSingleNode("/manifest/@package")).setValue("com.dakele.theme." + this.theme.getName());
            ((Attribute)document.selectSingleNode("/manifest/theme/@pluto:themeId")).setValue(this.theme.getName());
            format = OutputFormat.createPrettyPrint();
            fos = new FileOutputStream(manifestxml);
            writer = new XMLWriter(fos, format);
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            reader = new SAXReader();
            document = reader.read(new File(stringsCNxml));
            ((Element)document.selectSingleNode("//string[@name='app_name']")).setText(this.theme.getAlias());
            ((Element)document.selectSingleNode("//string[@name='theme_name']")).setText(this.theme.getName());
            ((Element)document.selectSingleNode("//string[@name='style_appearance_name']")).setText(this.theme.getAlias());
            ((Element)document.selectSingleNode("//string[@name='author']")).setText(this.theme.getAuthor());
            format = OutputFormat.createPrettyPrint();
            fos = new FileOutputStream(stringsCNxml);
            writer = new XMLWriter(fos, format);
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
    }

    public void save() {
        this.persistence();
    }

    private void persistence() {
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }
}

