/*
 * Decompiled with CFR 0.152.
 */
package org.mactian.handler;

import org.mactian.logic.pojo.Theme;
import org.mactian.logic.pojo.ThemeIcon;
import org.mactian.logic.util.FileUtils;

public class ThemeIconHandler {
    private Theme theme;

    public ThemeIconHandler(Theme theme) {
        this.theme = theme;
    }

    public void replace(ThemeIcon icon, String newImage) throws Exception {
        String iconFile = String.valueOf(this.theme.getPath()) + "/res/drawable-xhdpi" + "/" + icon.getId() + ".png";
        if (FileUtils.copy(newImage, iconFile, true)) {
            icon.setUrl(iconFile);
            this.theme.getIconsMapping().put(icon.getId(), icon);
            String xmlPath = String.valueOf(this.theme.getPath()) + "/res/xml";
            FileUtils.write(String.valueOf(xmlPath) + "/" + icon.getRef(), this.getClass().getResourceAsStream("/res/xml/" + icon.getRef()));
        }
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public Theme getTheme() {
        return this.theme;
    }
}

