/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.buffer;

import com.sun.xml.internal.stream.buffer.FragmentedArray;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.sax.SAXBufferCreator;
import com.sun.xml.internal.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.internal.stream.buffer.stax.StreamWriterBufferCreator;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MutableXMLStreamBuffer
extends XMLStreamBuffer {
    public static final int DEFAULT_ARRAY_SIZE = 512;

    public MutableXMLStreamBuffer() {
        this(512);
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public MutableXMLStreamBuffer(int n) {
        this._structure = new FragmentedArray<byte[]>(new byte[n]);
        this._structureStrings = new FragmentedArray<String[]>(new String[n]);
        this._contentCharactersBuffer = new FragmentedArray<char[]>(new char[4096]);
        this._contentObjects = new FragmentedArray<Object[]>(new Object[n]);
        ((byte[])this._structure.getArray())[0] = 0;
    }

    public void createFromXMLStreamReader(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        this.reset();
        StreamReaderBufferCreator streamReaderBufferCreator = new StreamReaderBufferCreator(this);
        streamReaderBufferCreator.create(xMLStreamReader);
    }

    public XMLStreamWriter createFromXMLStreamWriter() {
        this.reset();
        return new StreamWriterBufferCreator(this);
    }

    public SAXBufferCreator createFromSAXBufferCreator() {
        this.reset();
        SAXBufferCreator sAXBufferCreator = new SAXBufferCreator();
        sAXBufferCreator.setBuffer(this);
        return sAXBufferCreator;
    }

    public void createFromXMLReader(XMLReader xMLReader, InputStream inputStream) throws SAXException, IOException {
        this.createFromXMLReader(xMLReader, inputStream, null);
    }

    public void createFromXMLReader(XMLReader xMLReader, InputStream inputStream, String string) throws SAXException, IOException {
        this.reset();
        SAXBufferCreator sAXBufferCreator = new SAXBufferCreator(this);
        xMLReader.setContentHandler(sAXBufferCreator);
        xMLReader.setDTDHandler(sAXBufferCreator);
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXBufferCreator);
        sAXBufferCreator.create(xMLReader, inputStream, string);
    }

    public void reset() {
        this._contentObjectsPtr = 0;
        this._contentCharactersBufferPtr = 0;
        this._structureStringsPtr = 0;
        this._structurePtr = 0;
        ((byte[])this._structure.getArray())[0] = 0;
        this._contentObjects.setNext(null);
        Object[] objectArray = (Object[])this._contentObjects.getArray();
        for (int i = 0; i < objectArray.length && objectArray[i] != null; ++i) {
            objectArray[i] = null;
        }
        this.treeCount = 0;
    }

    protected void setHasInternedStrings(boolean bl) {
        this._hasInternedStrings = bl;
    }
}

