var oauth = require("oauth");

// Conf for the Twitter application
var twitterConsumerKey = "tPj4lyMH48NBmqwsu5U6EQkEx";
var twitterConsumerSecret = "5cDhfuzHfnUMehsoCOIiJ5FdmqioqZzmXN3vzskgR76MtUElqf";

// Create the consumer
var returnUrl = location.href.replace(/_generated_background_page/, "index");
var consumer = new oauth.OAuth(
	"https://twitter.com/oauth/request_token",
	"https://twitter.com/oauth/access_token",
	twitterConsumerKey,
	twitterConsumerSecret,
	"1.0A",
	returnUrl,
	"HMAC-SHA1"
);

// Check the validity of an access token and secret
exports.verifyCredentials = function (oauthAccessToken, oauthAccessTokenSecret, callback) {
	var url = "https://api.twitter.com/1.1/account/verify_credentials.json";
	consumer.get(url, oauthAccessToken, oauthAccessTokenSecret, function (error, data, response) {
		if (error) {
			callback({
				error: error
			});
		} else {
			callback({
				error: false,
				data: data,
				response: response
			});
		}
	});
};

// Get a request token
exports.getOAuthRequestToken = function (callback) {
	consumer.getOAuthRequestToken(function (error, oauthToken, oauthTokenSecret) {
		if (error) {
			callback({
				error: error
			});
		} else {
			callback({
				oauthToken: oauthToken,
				oauthTokenSecret: oauthTokenSecret,
				redirect: "https://twitter.com/oauth/authorize?oauth_token=" + oauthToken
			});
		}
	});
};

// Get an access token
exports.getOAuthAccessToken = function (oauthRequestToken, oauthRequestTokenSecret, oauth_verifier, callback) {
	consumer.getOAuthAccessToken(oauthRequestToken, oauthRequestTokenSecret, oauth_verifier, function (error, oauthAccessToken, oauthAccessTokenSecret) {
		if (error) {
			callback({
				error: error
			});
		} else {
			callback({
				oauthAccessToken: oauthAccessToken,
				oauthAccessTokenSecret: oauthAccessTokenSecret
			});
		}
	});
};

exports.tweetImage = function (text, image, oauth, callback1, callback2) {
	var url = "https://upload.twitter.com/1.1/media/upload.json";
	var oauthAccessToken = oauth.accessToken;
	var oauthAccessTokenSecret = oauth.accessTokenSecret;
	var body = {
		media_data: image
	};
	var contentType = "multipart/form-data";
	consumer.post(url, oauthAccessToken, oauthAccessTokenSecret, body, contentType, function (error, data, response) {
		if (error) {
			callback1({
				error: error
			});
		} else {
			callback1({
				error: false,
				data: data,
				response: response
			});
			var json = JSON.parse(data);
			var tweet = text + " #IndieGameSim";
			exports.postTweet(tweet, json.media_id_string, oauth, callback2);
		}
	});
};

// Post a tweet
exports.postTweet = function (text, media_id_string, oauth, callback) {
	var url = "https://api.twitter.com/1.1/statuses/update.json";
	var oauthAccessToken = oauth.accessToken;
	var oauthAccessTokenSecret = oauth.accessTokenSecret;
	var body = {
		status: text,
		media_ids: [media_id_string],
	};
	var contentType = null;
	consumer.post(url, oauthAccessToken, oauthAccessTokenSecret, body, contentType, function (error, data, response) {
		if (error) {
			callback({
				error: error
			});
		} else {
			callback({
				error: false,
				data: data,
				response: response
			});
		}
	});
};
