//==============================================================================
// Scn33p4: AI Scenario Script for scenario 33 player 4
//==============================================================================
/*
   AI owner:  Mike Kidd
   Scenario owner: Jeff Brown

   Overview:
   
   Player 4 is Norse, and serves to basically play defense and prevent the 
   HP from leaving his area in the first 30 minutes of gameplay.

   Player 4 will get upgrades, but doesn't train units.  His existing armies 
   are allocated to four defend plans.  Three are near the borders between player
   4 and the HP, the other is a general defense plan to protect the core of his
   town.
     
*/
//==============================================================================


include "scn lib.xs";


// *****************************************************************************
//
// Globals
//
// *****************************************************************************


// Cinematic blocks

const string cbDefendPoint = "2885";
const string cbAttackGather = "2890";
const string cbTownCenter = "2888";
const string cbGarg = "2898";       // Gargarensis's hideout
const string cbRouteA1 = "2891";      // East side
const string cbRouteA2 = "2892";
const string cbRouteA3 = "2893";
const string cbRouteB1 = "2891";      // Center
const string cbRouteB2 = "2892";
const string cbRouteB3 = "2894";
const string cbRouteC1 = "2891";      // West
const string cbRouteC2 = "2895";
const string cbRouteC3 = "2896";
const string cbDefend1 = "2987";
const string cbDefend2 = "2988";
const string cbDefend3 = "2989";


// Attack routes and queries
int   routeA = -1;
int   routeB = -1;
int   routeC = -1;


// Army control
int   lastAttackPlan = -1;       // Used to find "my army" for god power position info
int   defendPlan = -1;
int   defend1 = -1;
int   defend2 = -1;
int   defend3 = -1;
int   explorePlan = -1;

// The following are set in main() based on difficulty level.
int      nextAttackTime = 180000;   // Will be adjusted for the wakeup time
int      attackInterval = 240000;   // Attack every 4:00 
float    attackSize = 3.0;
float    attackMultiplier = 1.2;
int      maxAttackSize = 8;

//    Upgrade timer control
int      startTime = -1;
int      endTime = -1;


int   maintainQty1 = -1;         // Quantity to maintain
int   maintainUnit1 = -1;        // Unit type
int   maintainDelay1 = -1;       // Interval between training units
vector   maintainGather1 = cInvalidVector;
int   maintainID1 = -1;          // Maintain plan for primary military unit

int   maintainQty2 = -1;         // Quantity to maintain
int   maintainUnit2 = -1;        // Unit type
int   maintainDelay2 = -1;       // Interval between training units
vector   maintainGather2 = cInvalidVector;
int   maintainID2 = -1;          // Maintain plan for secondary military unit

int   maintainQty3 = -1;         // Quantity to maintain
int   maintainUnit3 = -1;        // Unit type
int   maintainDelay3 = -1;       // Interval between training units
vector   maintainGather3 = cInvalidVector;
int   maintainID3 = -1;          // Maintain plan for tertiary military unit

int   maintainQty4 = -1;         // Quantity to maintain
int   maintainUnit4 = -1;        // Unit type
int   maintainDelay4 = -1;       // Interval between training units
vector   maintainGather4 = cInvalidVector;
int   maintainID4 = -1;          // Maintain plan for quatenary military unit

int   maintainQtyScout = 1;
int   maintainUnitScout = cUnitTypeScout;
int   maintainDelayScout = 1;
vector   maintainGatherScout = cInvalidVector;
int   maintainIDScout = -1;      // Scout unit





// Misc.
int   age2Time = -1;       // Will be adjusted in main() for difficulty
int   age3Time = -1;        
int   age4Time = -1;       

int   difficulty = -1;     // Global to store difficulty, set early in main.



// *****************************************************************************
//
//                                FUNCTIONS
//
// *****************************************************************************


// Called by trigger when the cinematics are done

void wakeup(int parm=-1)
{
   static bool alreadyRun = false;
   aiEcho("Wakeup running at "+timeString()+".");
   if (alreadyRun == true)
      return;
   alreadyRun = true;

   startTime = xsGetTime();
   endTime = startTime + 20*60*1000;   // When does the army arrive?

   if (age2Time > 0)
      age2Time = age2Time + startTime; // Adjust for delay in wakeup.
   if (age3Time > 0)
      age3Time = age3Time + startTime;     
   if (age4Time > 0)
      age4Time = age4Time + startTime;
   if (nextAttackTime  > 0)
      nextAttackTime = nextAttackTime + startTime;

      // Init mid-priority defend plans to manage units at passes
   defend1 =aiPlanCreate("Defend Plan 1", cPlanDefend);
   if (defend1 >= 0)
   {
      aiPlanAddUnitType(defend1, cUnitTypeHuskarl, 0, 4, 4);    // Units around pass 1
      aiPlanAddUnitType(defend1, cUnitTypeHeroNorse, 0, 4, 4);
      aiPlanSetDesiredPriority(defend1, 30);                       // moderate, below scouting and attack but above general defense
      aiPlanSetVariableVector(defend1, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbDefend1));
      aiPlanSetVariableFloat(defend1, cDefendPlanEngageRange, 0, 30.0);
      aiPlanSetVariableBool(defend1, cDefendPlanPatrol, 0, false);
      aiPlanSetVariableFloat(defend1, cDefendPlanGatherDistance, 0, 15.0);
      aiPlanSetVariableInt(defend1, cDefendPlanRefreshFrequency, 0, 5);
      aiPlanSetNumberVariableValues(defend1, cDefendPlanAttackTypeID, 2, true);
      aiPlanSetUnitStance(defend1, cUnitStanceDefensive);
      aiPlanSetVariableInt(defend1, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
      aiPlanSetVariableInt(defend1, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);

      aiPlanSetInitialPosition(defend1, kbGetBlockPosition(cbAttackGather));
      aiPlanSetActive(defend1); 
      aiEcho("Creating defend1 plan.");
   }


   defend2 =aiPlanCreate("Defend Plan 2", cPlanDefend);
   if (defend2 >= 0)
   {
      aiPlanAddUnitType(defend2, cUnitTypeThrowingAxeman, 0, 8, 8);    // Units around pass 2
      aiPlanSetDesiredPriority(defend2, 30);                       // moderate, below scouting and attack but above general defense
      aiPlanSetVariableVector(defend2, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbDefend2));
      aiPlanSetVariableFloat(defend2, cDefendPlanEngageRange, 0, 30.0);
      aiPlanSetVariableBool(defend2, cDefendPlanPatrol, 0, false);
      aiPlanSetVariableFloat(defend2, cDefendPlanGatherDistance, 0, 15.0);
      aiPlanSetVariableInt(defend2, cDefendPlanRefreshFrequency, 0, 5);
      aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
      aiPlanSetUnitStance(defend2, cUnitStanceDefensive);
      aiPlanSetVariableInt(defend2, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
      aiPlanSetVariableInt(defend2, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);

      aiPlanSetInitialPosition(defend2, kbGetBlockPosition(cbAttackGather));
      aiPlanSetActive(defend2); 
      aiEcho("Creating defend2 plan.");
   }


   defend3 =aiPlanCreate("Defend Plan 3", cPlanDefend);
   if (defend3 >= 0)
   {
      aiPlanAddUnitType(defend3, cUnitTypeJarl, 0, 8, 8);    // Units around pass 3
      aiPlanSetDesiredPriority(defend3, 30);                       // moderate, below scouting and attack but above general defense
      aiPlanSetVariableVector(defend3, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbDefend3));
      aiPlanSetVariableFloat(defend3, cDefendPlanEngageRange, 0, 30.0);
      aiPlanSetVariableBool(defend3, cDefendPlanPatrol, 0, false);
      aiPlanSetVariableFloat(defend3, cDefendPlanGatherDistance, 0, 15.0);
      aiPlanSetVariableInt(defend3, cDefendPlanRefreshFrequency, 0, 5);
      aiPlanSetNumberVariableValues(defend3, cDefendPlanAttackTypeID, 2, true);
      aiPlanSetUnitStance(defend3, cUnitStanceDefensive);
      aiPlanSetVariableInt(defend3, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
      aiPlanSetVariableInt(defend3, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);

      aiPlanSetInitialPosition(defend3, kbGetBlockPosition(cbAttackGather));
      aiPlanSetActive(defend3); 
      aiEcho("Creating defend3 plan.");
   }


   // Init low-priority defend plan to manage all extra mil units
   defendPlan =aiPlanCreate("Defend Plan", cPlanDefend);
   if (defendPlan >= 0)
   {
      aiPlanAddUnitType(defendPlan, cUnitTypeHumanSoldier, 0, 200, 200);    // All unassigned mil units except giants
      aiPlanAddUnitType(defendPlan, cUnitTypeBallista, 0, 200, 200);
      aiPlanSetDesiredPriority(defendPlan, 10);                       // Way low, below scouting and attack
      aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbDefendPoint));
      aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 50.0);
      aiPlanSetVariableBool(defendPlan, cDefendPlanPatrol, 0, false);
      aiPlanSetVariableFloat(defendPlan, cDefendPlanGatherDistance, 0, 20.0);
      aiPlanSetVariableInt(defendPlan, cDefendPlanRefreshFrequency, 0, 5);
      aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
      aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
      aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);
      aiPlanSetUnitStance(defendPlan, cUnitStanceDefensive);
      aiPlanSetInitialPosition(defendPlan, kbGetBlockPosition(cbAttackGather));
      aiPlanSetActive(defendPlan); 
      aiEcho("Creating defend plan");
   }

   xsEnableRule("scout");
   xsEnableRule("attackGenerator");
   xsEnableRule("upgradeGenerator");
}





void attack(int size=0)
{
   int   attackID=aiPlanCreate("Attack at "+timeString(true)+" ", cPlanAttack);
   if (attackID < 0) 
      return;

   if (aiPlanSetVariableInt(attackID, cAttackPlanPlayerID, 0, 1) == false)
      return;

   if (aiPlanSetNumberVariableValues(attackID, cAttackPlanTargetTypeID, 3, true) == false)
      return;

   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 0, cUnitTypeUnit);
   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 1, cUnitTypeBuilding);
   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 2, cUnitTypeAbstractWall);


   
   switch(aiRandInt(3))
   {
   case 0:
      {
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeA);
         break;
      }
   case 1:
      {
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeB);
         break;
      }
   case 2:
      {
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeC);
         break;
      }
   }


   aiPlanSetVariableVector(attackID, cAttackPlanGatherPoint, 0, kbGetBlockPosition(cbAttackGather));
   aiPlanSetVariableFloat(attackID, cAttackPlanGatherDistance, 0, 20.0);


   aiPlanAddUnitType(attackID, maintainUnit1, 0, (size+8)/10, (size+8)/10);  // cyclops
   aiPlanAddUnitType(attackID, maintainUnit2, 0, (4*size+2)/10, (4*size+2)/10);  // hippikon
   aiPlanAddUnitType(attackID, maintainUnit3, 0, (5*size+5)/10, (5*size+5)/10);  // toxotes

   if ( (endTime - xsGetTime()) < 10*60*1000)
   {
      aiEcho("  adding hydra(s) to attack plan.");
      aiPlanAddUnitType(attackID, maintainUnit4, 0, (size+3)/5, (size+3)/5);      // hydra
   }

   aiPlanSetInitialPosition(attackID, kbGetBlockPosition(cbAttackGather));
   aiPlanSetRequiresAllNeedUnits(attackID, false);
   aiPlanSetDesiredPriority(attackID, 50);   // Less than scouting, more than defense
   aiPlanSetActive(attackID);
   aiEcho("Activating attack plan "+attackID+" with appx "+size+" units.");
   lastAttackPlan = attackID; // update the global var
}




void main()
{
   aiEcho("Starting Scn33p4.xs");

   //Calculate some areas.
   kbAreaCalculate(1200.0);
   aiRandSetSeed();
   kbSetTownLocation(kbGetBlockPosition(cbTownCenter));

/*
   aiSetAgeEventHandler(cAge2, "age2EventHandler");
   aiSetAgeEventHandler(cAge3, "age3EventHandler");
   aiSetAgeEventHandler(cAge4, "age4EventHandler");
*/
   aiSetAttackResponseDistance(10.0);

   // Kill escrows
   kbEscrowSetPercentage( cEconomyEscrowID, cAllResources, 0.0);
   kbEscrowSetPercentage( cMilitaryEscrowID, cAllResources, 0.0);
   kbEscrowAllocateCurrentResources();


   int   armyReserveSize = -1;   // Target size for total reserve army, to be adjusted for difficulty
   int   standardDelay = -1;     // Used to set unit-training delay times, adjusted for difficulty

   // Set difficulty vars
   difficulty = aiGetWorldDifficulty();
   aiEcho("Difficulty = "+difficulty);   

   switch(difficulty)      // Set up the attack control and age-up parameters
   {
   case 0:     // Easy
      {
         nextAttackTime = 1000;     // 1 sec
         attackInterval = 240000;   // 4 min
         attackSize = 3;          
         attackMultiplier = 1.3;    // 30% per interval
         maxAttackSize = 8;
         age2Time = -1;       // N/A
         age3Time = 1200000;  // 20 min
         age4Time = 40*60*1000;       
         armyReserveSize = 12;
         standardDelay = 1;  // seconds
         break;
      }
   case 1:     // Moderate
      {
         nextAttackTime = 1000;   // 1 sec 
         attackInterval = 180000;   // 3 min
         attackSize = 4.0;          
         attackMultiplier = 1.3;    // 20% per period
         maxAttackSize = 11;
         age2Time = -1;       // N/A
         age3Time = 720000;   // 12 min
         age4Time = 20*60*1000;      
         armyReserveSize = 16;
         standardDelay = 1;  // seconds
         break;
      }
   case 2:     // Difficult
      {
         nextAttackTime = 1000;     
         attackInterval = 120000;
         attackSize = 6.0;
         attackMultiplier = 1.3;    // 30% per period
         maxAttackSize = 15;
         age2Time = -1;       // N/A
         age3Time = 4*60*1000;   // 4 min
         age4Time = 12*60*1000;       
         armyReserveSize = 25;
         standardDelay = 1;  // seconds
         break;
      }
   case 3:     // Nightmare
      {
         nextAttackTime = 1000;
         attackInterval = 120000;
         attackSize = 8.0;
         attackMultiplier = 1.4;    // 40% per period
         maxAttackSize = 25;
         age2Time = -1;       // N/A
         age3Time = 1*60*1000;   // 1 min
         age4Time = 8*60*1000;       
         armyReserveSize = 40;
         standardDelay = 1;  // seconds
         break;
      }
   }



   // Set global unit control vars
   maintainQty1 = (armyReserveSize+8)/10;         // Quantity to maintain
   maintainUnit1 = cUnitTypeCyclops;        // Unit type
   maintainDelay1 = standardDelay;       // Interval between training units
   maintainGather1 = cInvalidVector;

   maintainQty2 = (4*armyReserveSize+2)/10;         // Quantity to maintain
   maintainUnit2 = cUnitTypeHippikon;        // Unit type
   maintainDelay2 = standardDelay;       // Interval between training units
   maintainGather2 = cInvalidVector;

   maintainQty3 = (4*armyReserveSize+6)/10;         // Quantity to maintain
   maintainUnit3 = cUnitTypeToxotes;        // Unit type
   maintainDelay3 = standardDelay;       // Interval between training units
   maintainGather3 = cInvalidVector;

   maintainQty4 = (armyReserveSize+5)/10;         // Quantity to maintain
   maintainUnit4 = cUnitTypeHydra;        // Unit type
   maintainDelay4 = standardDelay;       // Interval between training units
   maintainGather4 = cInvalidVector;


   maintainQtyScout = 1;
   maintainUnitScout = cUnitTypeRaven;
   maintainDelayScout = 1;
   maintainGatherScout = cInvalidVector;


   // Init attack routes
   routeA = attackRoute("Attack Route A", cbRouteA1, cbRouteA2, cbRouteA3);
   routeB = attackRoute("Attack Route B", cbRouteB1, cbRouteB2, cbRouteB3);
   routeC = attackRoute("Attack Route C", cbRouteC1, cbRouteC2, cbRouteC3);
/*
   // Init maintain plans
   if (maintainUnit1 > 0)
      maintainID1 = maintainUnit(maintainUnit1, maintainQty1, maintainGather1, maintainDelay1);
   if (maintainUnit2 > 0)
      maintainID2 = maintainUnit(maintainUnit2, maintainQty2, maintainGather2, maintainDelay2); 
   if (maintainUnit3 > 0)
      maintainID3 = maintainUnit(maintainUnit3, maintainQty3, maintainGather3, maintainDelay3);  
   if (maintainUnit4 > 0)
      maintainID4 = maintainUnit(maintainUnit4, maintainQty4, maintainGather4, maintainDelay4);  
   if (maintainUnitScout > 0)
      maintainIDScout = maintainUnit(maintainUnitScout, maintainQtyScout, maintainGatherScout, maintainDelayScout);

*/


/*
   // Initialize the target queries
   queryP1Units = kbUnitQueryCreate("Player 1 Units");
   configQuery(queryP1Units, cUnitTypeUnit, -1, cUnitStateAlive, 1);
*/

   wakeup(0); // Wake up immediately, don't wait for aiFunc trigger.
 
}







// *****************************************************************************
//
// RULES
//
// *****************************************************************************
/*rule cheatScout   // Spawn a fenris wolf if none exist
   active
   minInterval 15
{
   int count = -1;
   count = kbUnitCount(2, maintainUnitScout, cUnitStateAlive);
   if (count < maintainQtyScout)
      aiUnitCreateCheat( 2, maintainUnitScout, kbGetBlockPosition(cbAttackGather), "Scout group", maintainQtyScout - count); 

}*/



rule favorGenerator
   active
   minInterval 15
{
   aiResourceCheat( 2, cResourceFavor, 100.0 );    // Max out the favor every 15 seconds
   kbEscrowAllocateCurrentResources();             // Make sure the escrow knows about it.
}


rule scout
   inactive
   minInterval 5
{
   // just set up an explore plan
   int explorePlan = aiPlanCreate("Explore", cPlanExplore);
   if(explorePlan >= 0)
   {
      aiPlanSetVariableFloat( explorePlan, cExplorePlanLOSMultiplier,  0, 4.0 );
      aiPlanAddUnitType(explorePlan, maintainUnitScout, 1, 1, 1);
      aiPlanSetDesiredPriority(explorePlan, 90);
      aiPlanSetInitialPosition(explorePlan, kbGetBlockPosition(cbAttackGather));
      aiPlanSetActive(explorePlan);
   }

   int explore2 = aiPlanCreate("Explore 2", cPlanExplore);
   if(explore2 >= 0)
   {
      aiPlanSetVariableFloat( explore2, cExplorePlanLOSMultiplier,  0, 4.0 );
      aiPlanAddUnitType(explore2, maintainUnitScout, 1, 1, 1);
      aiPlanSetDesiredPriority(explore2, 90);
      aiPlanSetInitialPosition(explore2, kbGetBlockPosition(cbAttackGather));
      aiPlanSetActive(explore2);
   }

   xsDisableSelf();
}



/*
rule goToAge2
   inactive
   minInterval 10
{
   if ( xsGetTime() < age2Time)
      return;
   researchTech(cTechAge2Heimdall);
   xsDisableSelf();
}



rule goToAge3
   inactive
   mininterval 20
{
   if ( xsGetTime() < age3Time )
      return;
   researchTech(cTechAge3Njord);
   xsDisableSelf();
}


rule goToAge4
   inactive
   mininterval 20
{
   if ( xsGetTime() < age4Time )
      return;
   researchTech(cTechAge4Hel);
   xsDisableSelf();
}
*/



rule getAge2UnitUpgrades
   inactive
   minInterval 20
{
//   researchTech(cTechMediumInfantry);
//   researchTech(cTechMediumCavalry);
   xsDisableSelf();
}

rule getAge2ArmoryUpgrades
   inactive
   minInterval 20
{

   aiEcho("Getting age 2 armory upgrades");
   researchTech(cTechCopperWeapons);
   researchTech(cTechCopperMail);
   researchTech(cTechCopperShields);
   xsDisableSelf();
}

rule getAge3UnitUpgrades
   inactive
   minInterval 20
{

//   researchTech(cTechHeavyInfantry);
 //  researchTech(cTechHeavyCavalry);
   xsDisableSelf();
}

rule getAge3ArmoryUpgrades
   inactive
   minInterval 20
{
   aiEcho("Getting age 3 armory upgrades");
   researchTech(cTechBronzeWeapons);
   researchTech(cTechBronzeMail);
   researchTech(cTechBronzeShields);
   xsDisableSelf();
}

rule getAge4UnitUpgrades
   inactive
   minInterval 20
{

//   researchTech(cTechChampionInfantry);
//   researchTech(cTechChampionCavalry);
   xsDisableSelf();
}

rule getAge4ArmoryUpgrades
   inactive
   minInterval 20
{
   aiEcho("Getting age 4 armory upgrades");
   researchTech(cTechIronWeapons);
   researchTech(cTechIronMail);
   researchTech(cTechIronShields);
   xsDisableSelf();
}


rule upgradeGenerator
   minInterval 10
   inactive
{
   // Progressively get unit upgrades throughout
   // Take the time from startTime to endTime, divide into six segments.
   // At the end of each segment, get a set of unit or armory upgrades.



   static int interval = 0;
   static int nextTime = 0;
   static int count = 0;

   if (interval == 0) 
   {
      interval = (endTime - startTime)/6;
      nextTime = startTime + interval;
   }

   if (nextTime > xsGetTime())
      return;     // It is not yet our time.

   // It is time, do something
   switch( count )      // Activate the appropriate upgrade rule, reset nextTime timer.
   {
   case 0:
      {
         xsEnableRule("getAge2UnitUpgrades");
         count = count + 1;
         nextTime = nextTime + interval;
         break;
      }
   case 1:
      {
         xsEnableRule("getAge2ArmoryUpgrades");
         count = count + 1;
         nextTime = nextTime + interval;
         break;
      }
   case 2:
      {
         xsEnableRule("getAge3UnitUpgrades");
         count = count + 1;
         nextTime = nextTime + interval;
         break;
      }
   case 3:
      {
         xsEnableRule("getAge3ArmoryUpgrades");
         count = count + 1;
         nextTime = nextTime + interval;
         break;
      }
   case 4:
      {
         xsEnableRule("getAge4UnitUpgrades");
         count = count + 1;
         nextTime = nextTime + interval;
         break;
      }
   case 5:
      {
         xsEnableRule("getAge4ArmoryUpgrades");
         count = count + 1;
         xsDisableSelf();
         break;
      }
   }


}

rule attackGenerator
   minInterval 10
   inactive
{
xsDisableSelf();
return;

   //aiEcho("attack check running, next time is "+nextAttackTime);
   if ( xsGetTime() < nextAttackTime )
      return;

   attack(attackSize);
   nextAttackTime = xsGetTime() + attackInterval;
   attackSize = attackSize * attackMultiplier;
   if (attackSize > maxAttackSize)
      attackSize = maxAttackSize;
   aiEcho("Next attack size will be "+attackSize+".");
}





/*
rule useUndermine // Look for 2 walls near my army
   minInterval 5
   inactive
{
   int targetUnit = -1;
   int attackArmyID = -1;

   if (lastAttackPlan < 0)
      return;
   vector pVec = aiPlanGetLocation(lastAttackPlan);
   if (xsVectorGetX(pVec)<0)
      return;

   static int tempQuery = -1;
   if (tempQuery < 0)
   {  // Doesn't exist, set it up
      tempQuery = kbUnitQueryCreate("useUndermine");

      if ( configQuery(tempQuery, cUnitTypeAbstractWall, -1, cUnitStateAliveOrBuilding, 1, pVec, true, 25) == false)
         return;
   }
   else
      kbUnitQuerySetPosition(tempQuery, pVec); // Because pVec changes as army moves

   kbUnitQueryResetResults(tempQuery);
   int targetCount = kbUnitQueryExecute(tempQuery);  

   if (targetCount < 2)
      return;
   targetUnit = kbUnitQueryGetResult(tempQuery, 0);  // grab first wall

   // confirm LOS
   if ( kbUnitVisible(targetUnit) != true )
   {
      aiEcho("Undermine: Don't have LOS for unit "+targetUnit+" "+kbGetProtoUnitName(targetUnit));
      return;
   }

   aiEcho("Using Undermine at "+kbUnitGetPosition(targetUnit));
   if ( aiCastGodPowerAtPosition(cTechUndermine, kbUnitGetPosition(targetUnit)) == true)
      xsDisableSelf();
   else 
      aiEcho("Undermine failed at "+kbUnitGetPosition(targetUnit));
}
*/

