//==============================================================================
// Scn25p3: AI Scenario Script for scenario 25 player 3
//==============================================================================
/*
   AI owner:  Dave Leary
   Scenario owner: Joe "The Golem" Gillum

   Overview: Very basic AI script that trains giants and einherjar.
	
   This AI takes the majority of generated units and sends them to attack the HP,
	leaving a few behind at the gather point for town defense.  It relies on P2 to
	do its scouting for it.  Population is provided by houses at the back of the
	map.
*/
//==============================================================================
include "scn lib.xs";

//==============================================================================
// Set Town Location
//==============================================================================
void setTownLocation(void)
{
   //Look for the "Town Location" marker.
   kbSetTownLocation(kbGetBlockPosition("8086"));
}

//==============================================================================
// miscStartup
//==============================================================================
void miscStartup(void)
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

   //Startup message(s).
   aiEcho("");
   aiEcho("");
   aiEcho("Scn25P3 AI Start, filename='"+cFilename+"'.");
	aiEcho("Difficulty Level="+difflevel+".");
   //Spit out the map size.
   aiEcho("  Map size is ("+kbGetMapXSize()+", "+kbGetMapZSize()+").");
   //Cheat like a bastard.  Once only, though.
   kbLookAtAllUnitsOnMap();
   //Calculate some areas.
   kbAreaCalculate(1200.0);
   //Set our town location.
   setTownLocation();
	//Reset random seeds
	aiRandSetSeed();

	//Allocate all resources to the root escrow by setting percentage of military/economy to 0.
	kbEscrowSetPercentage( cEconomyEscrowID, cAllResources, 0.0 );
	kbEscrowSetPercentage( cMilitaryEscrowID, cAllResources, 0.0 );

   //Allocate all resources
   kbEscrowAllocateCurrentResources();
}

//==============================================================================
//==============================================================================
// Attack stuff.
//==============================================================================
//==============================================================================
// Shared variables.
int numberAttacks=0;
int attackPlayerID=-1;

// Attack vars.
int attackPlanID=-1;

// Saved maintain plan IDs
int maintainPlan1ID=-1;
int maintainPlan2ID=-1;

// Unit types
int attackerUnitTypeID1=cUnitTypeFrostGiant;
int attackerUnitTypeID2=cUnitTypeEinheriar;

//==============================================================================
// initAttack: Creates attack routes, etc.
//==============================================================================
void initAttack(int playerID=-1)
{
   //Destroy all previous attacks (if this isn't the player we're already attacking.)
   if (playerID != attackPlayerID)
   {
      //Reset the attack player ID.
      attackPlayerID=-1;
      //Destroy any previous attack plan.
      aiPlanDestroy(attackPlanID);
      attackPlanID=-1;

      //Reset the number of attacks.
      numberAttacks=0;
   }

   //Save the player to attack.
   attackPlayerID=playerID;
}

//==============================================================================
// setupAttack
//==============================================================================
bool setupAttack(int playerID=-1)
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

	//Info.
	aiEcho("Attacking Player "+playerID+".");

   //If the player to attack doesn't match, init the attack.
   if (attackPlayerID != playerID)
   {
      initAttack(playerID);
      if (attackPlayerID < 0)
         return(false);
   }

   //Create an attack plan.
   int newAttackPlanID=aiPlanCreate("Attack Player"+attackPlayerID+" Attempt"+numberAttacks, cPlanAttack);
   if (newAttackPlanID < 0)
      return(false);

   //Target player (required).  This must work.
   if (aiPlanSetVariableInt(newAttackPlanID, cAttackPlanPlayerID, 0, attackPlayerID) == false)
      return(false);

   //Gather point.
	vector gatherPoint=kbGetBlockPosition("8086");

	//Set the target type.  This must work.
   if (aiPlanSetNumberVariableValues(newAttackPlanID, cAttackPlanTargetTypeID, 2, true) == false)
      return(false);

   aiPlanSetNumberVariableValues(newAttackPlanID, cAttackPlanTargetTypeID, 2, true);
	
	//Unit types to attack.
   aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 0, cUnitTypeUnit);
	aiPlanSetVariableInt(newAttackPlanID, cAttackPlanTargetTypeID, 1, cUnitTypeBuilding);

   //Set the gather point and gather point distance.
   aiPlanSetVariableVector(newAttackPlanID, cAttackPlanGatherPoint, 0, gatherPoint);
   aiPlanSetVariableFloat(newAttackPlanID, cAttackPlanGatherDistance, 0, 25.0);

	//Add the unit types to the plan - giants...
	if ( difflevel < 2 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID1, 0, 1, 1);
	}
	else if ( difflevel == 2 )
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID1, 0, 2, 2);
	}
	else
	{
		aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID1, 0, 3, 3);
	}
	//...and einhariwhatsises...
	// aiPlanAddUnitType(newAttackPlanID, attackerUnitTypeID2, 2, 4, 4);
	
   //Set the initial position.
   aiPlanSetInitialPosition(newAttackPlanID, gatherPoint);

   //Plan requires all need units to work (can be false).
   aiPlanSetRequiresAllNeedUnits(newAttackPlanID, true);
   
	//Activate the plan.
   aiPlanSetActive(newAttackPlanID);

   //Now, save the attack plan ID appropriately.
   aiPlanSetOrphan(attackPlanID, true);
   attackPlanID=newAttackPlanID;

   //Increment our overall number of attacks.
   numberAttacks++;
}

//==============================================================================
// Attack Generator - Send dudes now!  Or, well, soon.  Every 150 seconds.
//==============================================================================
rule attackGenerator
   minInterval 270
   inactive
   group AttackRules
{
   //See how many "idle" attack plans we have.  Don't create any more if we have
   //idle plans.
   int numberIdleAttackPlans=aiGetNumberIdlePlans(cPlanAttack);

   if (numberIdleAttackPlans > 0)
      return;

   //If we have enough unassigned military units, create a new attack plan.
   int numberAvailableUnits=aiNumberUnassignedUnits(attackerUnitTypeID1);
   aiEcho("There are "+numberAvailableUnits+" giants available for a new attack.");
   
	if (numberAvailableUnits >= 1)
		setupAttack(1);
}

//==============================================================================
// Attack Enabler
//==============================================================================
rule attackEnabler
   minInterval 500
   active
   group AttackRules
{
	aiEcho("*** ATTACKS ENABLED - P3 ***");
	xsEnableRule("attackGenerator");
	xsDisableSelf();
}

//==============================================================================
// Favor cheat 
//==============================================================================
rule favorCheat
   minInterval 60
   active
   group AttackRules
{
	// Cheat for favor.  It's tough to be Norse.
	aiResourceCheat( 3, cResourceFavor, 100.0 );
}

//==============================================================================
// MAIN.
//==============================================================================
void main(void)
{
	vector gatherPoint=kbGetBlockPosition("8086");
	
	// Locations for spawning fun
	miscStartup();

   //Maintain giants - three total, one that gets sent on easy/moderate, more that get sent
	// on other levels.
   maintainPlan1ID=aiPlanCreate("Maintain "+kbGetProtoUnitName(attackerUnitTypeID1), cPlanTrain);
   if (maintainPlan1ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanUnitType, 0, attackerUnitTypeID1);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanNumberToMaintain, 0, 3);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainPlan1ID, cTrainPlanFrequency, 0, 90);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan1ID, cTrainPlanGatherPoint, 0, gatherPoint);
      //Activate the plan.
      aiPlanSetActive(maintainPlan1ID);
   }

	/*
	//Maintain einherjar - six total, four get sent at a time.
   maintainPlan2ID=aiPlanCreate("Maintain 6 "+kbGetProtoUnitName(attackerUnitTypeID2), cPlanTrain);
   if (maintainPlan2ID >= 0)
   {
		//Must set the type of unit to train.
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanUnitType, 0, attackerUnitTypeID2);
      //You can limit the number of units that are ever trained by this plan with this call.
      //aiPlanSetVariableInt(maintainPlanID, cTrainPlanNumberToTrain, 0, 25);
      //Set the number of units to maintain in the world at one time.
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanNumberToMaintain, 0, 6);
      //Don't train units too fast
      aiPlanSetVariableInt(maintainPlan2ID, cTrainPlanFrequency, 0, 20);
      //Set a gather point.
      aiPlanSetVariableVector(maintainPlan2ID, cTrainPlanGatherPoint, 0, gatherPoint);
      //Activate the plan.
      aiPlanSetActive(maintainPlan2ID);
   }
	*/
}