//==============================================================================
// Scn14p2: AI Scenario Script for scenario 14 player 2
//==============================================================================
/*
   AI owner:  Mike Kidd
   Scenario owner: Jeff Brown

   Overview:
   The player needs to dig our a relic on the south side of the map.  He must choose
   between dedicating villagers to digging, and using the to collect resources, build
   buildings, and raise defenses.
   
   The CP units spawn and the north end of three channel, each blocked by an HP wall.  
   When these units spawn, a trigger calls the spawn() function, with an int parameter
   that identifies the channel.  The script then counts how many unassigned military units
   exist at the head of that channel, and creates and attack plan for them.

   Initially, the attack plans start with three queries for targets:  Military units, then 
   buildings, then walls (necessary to allow wall-busting).  After the time indicated by 
   "timeToGetAggressive" (adjusted by the wakeup time), the first query is modified to 
   allow the attack plans to attack any units, including the villagers.

   Difficulty: Not implemented (to be driven by triggers).
*/
//==============================================================================


include "scn lib.xs";

// Globals


// Cinematic block markers
const string   cbPit = "2844";         // The primary target
const string   cbPlainEast = "2845";   // Near the HP's buildings
const string   cbGateEast = "2846";
const string   cbGateCenter = "2847";
const string   cbGateWest = "2848";
const string   cbSpawnEast = "RMU6";
const string   cbSpawnCenter = "RMU5";
const string   cbSpawnWest = "RMU4";

int timeToGetAggressive = 480000;        // Time to switch AI to aggressive mode.  Will add wake-up delay time to this number.

int   queryMilitaryUnits = -1;           // Used before timeToGetAggressive to hit mil units 
int   queryBuildingsEast = -1;               // Ditto for buildings
int   queryAllUnits = -1;                    // Used after timeToGetAggressive to hit all units and buildings
int   queryAllBuildings = -1;                // ditto
int   queryWalls = -1;

int   querySpawnWest = -1;
int   querySpawnCenter = -1;  
int   querySpawnEast = -1;                   // Used to search for spawned CP military units
// *****************************************************************************
//
//                                FUNCTIONS
//
// *****************************************************************************



// Called by a trigger, to let AI know that the game has started
void wakeup(int parm=-1)
{
   aiEcho("Wakeup running at "+xsGetTime()/1000);
   timeToGetAggressive = timeToGetAggressive + xsGetTime();    // Adjust for delay in wakeup. 
   

}



void age2EventHandler(int bogus=-1)
{
}



void age3EventHandler(int bogus=-1)
{
}


void age4EventHandler(int bogus=-1)
{
}


void launchAttack(vector start=vector(-1,-1,-1), int query=-1, int count=-1)
{

   int attackID = aiPlanCreate("Attack at "+(xsGetTime()/1000), cPlanAttack);
   if (attackID < 0)
      return;
   if (aiPlanSetVariableInt(attackID, cAttackPlanPlayerID, 0, 1) == false)
      return;


   aiPlanSetVariableVector(attackID, cAttackPlanGatherPoint, 0, start);
   aiPlanSetVariableFloat(attackID, cAttackPlanGatherDistance, 0, 400.0);  // In case units from opposite ends get called  
   aiPlanSetInitialPosition( attackID, start);
   aiPlanAddUnitType(attackID, cUnitTypeMilitary, 1, count, count);
  
   aiPlanSetNumberVariableValues( attackID, cAttackPlanQueryID, 3);

   
   if (xsGetTime() > timeToGetAggressive)
   {
      aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 0, queryAllUnits);
      aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 1, queryAllBuildings);
      aiEcho("Attack plan "+attackID+" will attack any units or buildings.");
//      aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeGate);
//      aiPlanSetInitialPosition(attackID, kbGetBlockPosition(cbGate));
   }
   else
   {
      aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 0, queryMilitaryUnits);
      aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 1, queryBuildingsEast);
      aiEcho("Attack plan "+attackID+" will attack buildings or military units in the east.");
//      aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeGate);
//      aiPlanSetInitialPosition(attackID, kbGetBlockPosition(cbGate));
   }

   aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 2, queryWalls);

   aiPlanSetRequiresAllNeedUnits(attackID, true);
   aiPlanSetActive(attackID);
}








// Called via trigger when an army is available in one of the channels.  ChannelID indicates which channel has the units.
void spawn(int channelID=-1)
{    
   int targetCount = -1;

   aiEcho("Spawn firing, channelID = "+channelID);
   switch(channelID)
   {
   case 0:
      {
         //check east
         targetCount = getUnassignedUnitCount(kbGetBlockPosition(cbSpawnEast), 25.0, 2, cUnitTypeMilitary);
         aiEcho("Found "+targetCount+" units in the east channel.");
         if (targetCount > 0)
         {
            launchAttack(kbGetBlockPosition(cbSpawnEast), querySpawnEast, targetCount);
         }
      break;
      }
   case 1:
      {
         //check center
         targetCount = getUnassignedUnitCount(kbGetBlockPosition(cbSpawnCenter), 25.0, 2, cUnitTypeMilitary);
         aiEcho("Found "+targetCount+" units in the center channel.");
         if (targetCount > 0)
         {
            launchAttack(kbGetBlockPosition(cbSpawnCenter), querySpawnCenter, targetCount);
         }
         break;
      }
   case 2:
      {
         //check west
         targetCount = getUnassignedUnitCount(kbGetBlockPosition(cbSpawnWest), 25.0, 2, cUnitTypeMilitary); 
         aiEcho("Found "+targetCount+" units in the west channel.");
         if (targetCount > 0)
         {
            launchAttack(kbGetBlockPosition(cbSpawnWest), querySpawnWest, targetCount);
         }
         break;
      }
   }
}



void main()
{
   aiEcho("Starting Scn14p2.xs");
//   kbSetTownLocation(kbGetBlockPosition(cbGate));

   //Calculate some areas.
   kbAreaCalculate(1200.0);

   aiRandSetSeed();

   aiSetAgeEventHandler(cAge2, "age2EventHandler");
   aiSetAgeEventHandler(cAge3, "age3EventHandler");
   aiSetAgeEventHandler(cAge4, "age4EventHandler");

   // Create all the attack targeting queries
   queryMilitaryUnits = kbUnitQueryCreate("East military units");
   if (queryMilitaryUnits < 0)
      aiEcho("Query failed");
   // Hacked out the east geo limit for now...see if that's more fun.
   configQuery(queryMilitaryUnits, cUnitTypeMilitary, -1, cUnitStateAlive, 1/*, kbGetBlockPosition(cbPlainEast), false, 50.0*/);

   queryBuildingsEast = kbUnitQueryCreate("East buildings");
   if (queryBuildingsEast < 0)
      aiEcho("Query failed");
   configQuery(queryBuildingsEast, cUnitTypeBuilding, -1, cUnitStateAliveOrBuilding, 1, kbGetBlockPosition(cbPlainEast), false, 50.0);

   queryAllUnits = kbUnitQueryCreate("All units");
   if (queryAllUnits < 0)
      aiEcho("Query failed");
   configQuery(queryAllUnits, cUnitTypeUnit, -1, cUnitStateAlive, 1);

   queryAllBuildings = kbUnitQueryCreate("All buildings");
   if (queryAllBuildings < 0)
      aiEcho("Query failed");
   configQuery(queryAllBuildings, cUnitTypeBuilding, -1, cUnitStateAliveOrBuilding, 1);

   queryWalls = kbUnitQueryCreate("All walls");
   if (queryWalls < 0)
      aiEcho("Query failed");
   configQuery(queryWalls, cUnitTypeAbstractWall, -1, cUnitStateAliveOrBuilding, 1);

   querySpawnWest = kbUnitQueryCreate("checkWestStart");    // Look for CP units
   if ( configQuery(querySpawnWest, cUnitTypeMilitary, -1, cUnitStateAlive, 2, kbGetBlockPosition(cbSpawnWest), true, 30) == false)
      aiEcho("Query failed");
   querySpawnCenter = kbUnitQueryCreate("checkCenterStart");    // Look for CP units
   if ( configQuery(querySpawnCenter, cUnitTypeMilitary, -1, cUnitStateAlive, 2, kbGetBlockPosition(cbSpawnCenter), true, 30) == false)
      aiEcho("Query failed");
   querySpawnEast = kbUnitQueryCreate("checkEastStart");    // Look for CP units
   if ( configQuery(querySpawnEast, cUnitTypeMilitary, -1, cUnitStateAlive, 2, kbGetBlockPosition(cbSpawnEast), true, 30) == false)
      aiEcho("Query failed");
}






// *****************************************************************************
//
// RULES
//
// *****************************************************************************



rule changeQuery        // Changes the initial attack plan target query from cUnitTypeMilitary to cUnitTypeUnit.
   active
   minInterval 10
{
      if (xsGetTime() < timeToGetAggressive)
         return;

   kbUnitQuerySetUnitType(queryMilitaryUnits, cUnitTypeUnit);
   xsDisableSelf();
}