//==============================================================================
// Scn12p2: AI Scenario Script for scenario 12 player 2
//==============================================================================
/*
   AI owner:  Mike Kidd
   Scenario owner: Jeff Brown

   Overview:
   The human player starts with a small army and three heroes,and regularly 
   receives reinforcements at the starting position.  His goal is to destroy
   the giant ram before the gates are broken down.

   The AI operates by taking units that are trigger-spawned, and then sending 
   them to defend the ram (75%) or intercept the HP's units at the "bridge" (25%).  

   Many of the unit spawnings are based on the percent damage to the ram, with the
   intent being to provide more and more opposition as the player gets closer 
   to winning.

   Each time a set of units are spawned, a trigger calls the spawn() function and
   passes an int that indicates which of three spawning areas has the new units.

   The CP can use God Powers to support its armies, but curse is not allowed for
   the first 5 minutes of the game.  The CP does not age up.

   Difficulty: Controlled by triggers.
     

*/
//==============================================================================


include "scn lib.xs";

// Globals

bool  creatingDefendPlan = false;      // flipped to true while defend plan is gathering initial units.
int   currentDefendPlan = -1;          // Used to monitor the most recent defend plan until it has its initial units
int   defendPlanSize = -1;             // Number of units wanted for this plan

// Cinematic block markers
const string cbNorthStart = "1923";
const string cbEastStart = "1924";
const string cbSouthStart = "1925";
const string cbSouthPass = "1922";
const string cbGate = "1921";



// *****************************************************************************
//
//                                FUNCTIONS
//
// *****************************************************************************



/*
void launchAttack(vector start=vector(-1,-1,-1), int query=-1, int count=-1)
{
   static int attackQuery = -1;     // Attack at gate
   static int attackQuery2 = -1;    // Attack at pass
   int attackID = aiPlanCreate("Attack at "+(xsGetTime()/1000), cPlanAttack);
   if (attackID < 0)
      return;
   if (aiPlanSetVariableInt(attackID, cAttackPlanPlayerID, 0, 1) == false)
      return;
   if (attackQuery < 0)
   {
      attackQuery = kbUnitQueryCreate("Attack Gate");
      configQuery(attackQuery, cUnitTypeUnit, -1, cUnitStateAlive, 1, kbGetBlockPosition(cbGate), false, 75.0);
   }
   if (attackQuery2 < 0)
   {
      attackQuery2 = kbUnitQueryCreate("Attack Pass");
      configQuery(attackQuery2, cUnitTypeUnit, -1, cUnitStateAlive, 1, kbGetBlockPosition(cbSouthPass), false, 50.0);
   }

   aiPlanSetVariableVector(attackID, cAttackPlanGatherPoint, 0, start);
   aiPlanSetVariableFloat(attackID, cAttackPlanGatherDistance, 0, 50.0); 
   aiPlanSetInitialPosition( attackID, start);
   aiPlanAddUnitType(attackID, cUnitTypeMilitary, 1, count, count);

   // 75% odds of getting gate, 25% at pass
   if (aiRandInt(4) > 0)
   {
      aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 0, attackQuery);  // Query for units within 75m of the ram
//      aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeGate);
      aiPlanSetInitialPosition(attackID, start);
      aiEcho("Plan "+attackID+" will attack the gate starting from "+start+".");
kbUnitQueryExecute(attackQuery);
echoQuery(attackQuery);
   }
   else
   {
      aiPlanSetVariableInt(attackID, cAttackPlanQueryID, 0, attackQuery2);    // Query for units within 50m of the south pass
//      aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, routeSouthPass);
      aiPlanSetInitialPosition(attackID, start);
      aiEcho("Plan "+attackID+" will attack the south pass starting from "+start+".");
kbUnitQueryExecute(attackQuery2);
echoQuery(attackQuery2);
   }

   aiPlanSetRequiresAllNeedUnits(attackID, true);
   aiPlanSetActive(attackID);
   aiEcho("Activating attack plan "+attackID);
}
*/

/*
void checkNorthStart()   // Defend plan version
{
   int targetCount = 0;
   targetCount = getUnassignedUnitCount(kbGetBlockPosition(cbNorthStart), 50.0, cMyID, cUnitTypeMilitary);
   int vilCount = 0;
 
   int query=-1;           // Query to find the villagers, if any.

   query = kbUnitQueryCreate("Villagers");
   if (query < 0)
      return();

   configQuery(query, cUnitTypeVillagerGreek, -1, cUnitStateAlive, cMyID, kbGetBlockPosition(cbNorthStart), true, 50.0);
   kbUnitQueryResetResults(query);
   vilCount = kbUnitQueryExecute(query);

   aiEcho("Found "+targetCount+" units in North pass.");
   int defendPlan =aiPlanCreate("Defend Plan", cPlanDefend);
   if (defendPlan >= 0)
   {
      aiPlanAddUnitType(defendPlan, cUnitTypeMilitary, 0, targetCount, targetCount);    // Unassigned mil units
      aiPlanSetDesiredPriority(defendPlan, 50);                       // Way low, below scouting and attack
      aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 60);
      aiPlanSetVariableBool(defendPlan, cDefendPlanPatrol, 0, false);
      aiPlanSetVariableFloat(defendPlan, cDefendPlanGatherDistance, 0, 20.0);
      aiPlanSetInitialPosition(defendPlan, kbGetBlockPosition(cbNorthStart));
      aiPlanSetUnitStance(defendPlan, cUnitStanceDefensive);

      aiPlanSetVariableInt(defendPlan, cDefendPlanRefreshFrequency, 0, 5);

      if (vilCount < 1) // No vills, just get units
      {
         if (aiRandInt(4) > 0)   // 1 in 4
           aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbSouthPass));
         else
            aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbGate));
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);
      }
      else
      {     // Protect the villagers
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanDefendTargetID, vilCount, true);
         aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbNorthStart));

         int i = 0;
         for (i=0; < vilCount)
         {
            aiPlanSetVariableInt(defendPlan, cDefendPlanDefendTargetID, i, kbUnitQueryGetResult(query, i)); // Add this vill to the list
         }
         aiEcho("Added "+vilCount+" villagers to defend list.");
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);      }

      aiPlanSetActive(defendPlan); 
//    aiPlanSetNoMoreUnits(defendPlan, true);
      aiEcho("Creating defend plan");
   }
}



void checkEastStart()   // Defend plan version
{
   int targetCount = 0;
   targetCount = getUnassignedUnitCount(kbGetBlockPosition(cbEastStart), 50.0, cMyID, cUnitTypeMilitary);
   int vilCount = 0;
 
   int query=-1;           // Query to find the villagers, if any.

   query = kbUnitQueryCreate("Villagers");
   if (query < 0)
      return();

   configQuery(query, cUnitTypeVillagerGreek, -1, cUnitStateAlive, cMyID, kbGetBlockPosition(cbEastStart), true, 50.0);
   kbUnitQueryResetResults(query);
   vilCount = kbUnitQueryExecute(query);

   aiEcho("Found "+targetCount+" units in East pass.");
   int defendPlan =aiPlanCreate("Defend Plan", cPlanDefend);
   if (defendPlan >= 0)
   {
      aiPlanAddUnitType(defendPlan, cUnitTypeMilitary, 0, targetCount, targetCount);    
      aiPlanSetDesiredPriority(defendPlan, 50);                       
      aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 60);
      aiPlanSetVariableBool(defendPlan, cDefendPlanPatrol, 0, false);
//      aiPlanSetVariableVector(defendPlan, cDefendPlanGatherPoint, 0, kbGetBlockPosition(cbEastStart));
      aiPlanSetVariableFloat(defendPlan, cDefendPlanGatherDistance, 0, 20.0);
      aiPlanSetInitialPosition(defendPlan, kbGetBlockPosition(cbEastStart));
      aiPlanSetUnitStance(defendPlan, cUnitStanceDefensive);

      aiPlanSetVariableInt(defendPlan, cDefendPlanRefreshFrequency, 0, 5);

      if (vilCount < 1) // No vills, just get units
      {
         if (aiRandInt(4) > 0)   // 1 in 4
           aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbSouthPass));
         else
            aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbGate));         
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);
      }
      else
      {
         aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbEastStart));
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanDefendTargetID, vilCount, true);
         int i = 0;
         for (i=0; < vilCount)
         {
            aiPlanSetVariableInt(defendPlan, cDefendPlanDefendTargetID, i, kbUnitQueryGetResult(query, i)); // Add this vill to the list
         }
         aiEcho("Added "+vilCount+" villagers to defend list.");
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);
      }

      aiPlanSetActive(defendPlan); 
//    aiPlanSetNoMoreUnits(defendPlan, true);
      aiEcho("Creating defend plan");
   }
}



void checkSouthStart()   // Defend plan version
{
   int targetCount = 0;
   targetCount = getUnassignedUnitCount(kbGetBlockPosition(cbSouthStart), 50.0, cMyID, cUnitTypeMilitary);
   int vilCount = 0;
 
   int query=-1;           // Query to find the villagers, if any.

   query = kbUnitQueryCreate("Villagers");
   if (query < 0)
      return();

   configQuery(query, cUnitTypeVillagerGreek, -1, cUnitStateAlive, cMyID, kbGetBlockPosition(cbSouthStart), true, 50.0);
   kbUnitQueryResetResults(query);
   vilCount = kbUnitQueryExecute(query);

   aiEcho("Found "+targetCount+" units in South pass.");
   int defendPlan =aiPlanCreate("Defend Plan", cPlanDefend);
   if (defendPlan >= 0)
   {
      aiPlanAddUnitType(defendPlan, cUnitTypeMilitary, 0, targetCount, targetCount);    // Unassigned mil units
      aiPlanSetDesiredPriority(defendPlan, 50);                       // Way low, below scouting and attack
      aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 60);
      aiPlanSetVariableBool(defendPlan, cDefendPlanPatrol, 0, false);
      aiPlanSetVariableFloat(defendPlan, cDefendPlanGatherDistance, 0, 20.0);
      aiPlanSetInitialPosition(defendPlan, kbGetBlockPosition(cbSouthStart));
      aiPlanSetUnitStance(defendPlan, cUnitStanceDefensive);

      aiPlanSetVariableInt(defendPlan, cDefendPlanRefreshFrequency, 0, 5);

      if (vilCount < 1) // No vills, just get units
      {
         if (aiRandInt(4) > 0)   // 1 in 4
           aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbSouthPass));
         else
            aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbGate));         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);
      }
      else
      {
         aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbSouthStart));
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanDefendTargetID, vilCount, true);
         int i = 0;
         for (i=0; < vilCount)
         {
            aiPlanSetVariableInt(defendPlan, cDefendPlanDefendTargetID, i, kbUnitQueryGetResult(query, i)); // Add this vill to the list
         }
         aiEcho("Added "+vilCount+" villagers to defend list.");
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);      }

      aiPlanSetActive(defendPlan); 
//    aiPlanSetNoMoreUnits(defendPlan, true);
      aiEcho("Creating defend plan");
   }
}
*/
/*
void checkNorthStart()
//   inactive
//   minInterval 15
{
//   static int northStartQuery = -1;
//   static int lastTime = -30000;
   int targetCount = -1;

//   if (xsGetTime() < (lastTime+25000) )
//      return;     // suppress if we've picked up units here in the last 25 seconds, to avoid multiple tasking

   targetCount = getUnassignedUnitCount(kbGetBlockPosition(cbNorthStart), 50.0, cMyID, cUnitTypeMilitary);

   aiEcho("Found "+targetCount+" units in North pass.");
   if (targetCount > 0)
   {
      launchAttack(kbGetBlockPosition(cbNorthStart), northStartQuery, targetCount);
//      lastTime = xsGetTime();
   }
}*/



/*
void checkEastStart()
//   inactive
//   minInterval 15
{
//   static int eastStartQuery = -1;
//   static int lastTime = -30000;
   int targetCount = -1;

//   if (xsGetTime() < (lastTime+25000) )
//      return;     // suppress if we've picked up units here in the last 25 seconds, to avoid multiple tasking

   targetCount = getUnassignedUnitCount(kbGetBlockPosition(cbEastStart), 50.0, cMyID, cUnitTypeMilitary);


   aiEcho("Found "+targetCount+" units in East pass.");
   if (targetCount > 0)
   {
      launchAttack(kbGetBlockPosition(cbEastStart), eastStartQuery, targetCount);
//      lastTime = xsGetTime();
   }
}


void checkSouthStart()
//   inactive
//   minInterval 15
{
//  static int southStartQuery = -1;
//   static int lastTime = -30000;
   int targetCount = -1;

//   if (xsGetTime() < (lastTime+25000) )
//      return;     // suppress if we've picked up units here in the last 25 seconds, to avoid multiple tasking

   targetCount = getUnassignedUnitCount(kbGetBlockPosition(cbSouthStart), 50.0, cMyID, cUnitTypeMilitary);

   aiEcho("Found "+targetCount+" units in South pass.");
   if (targetCount > 0)
   {
      launchAttack(kbGetBlockPosition(cbSouthStart), southStartQuery, targetCount);
//      lastTime = xsGetTime();
   }
}
*/

/*
// Called via trigger when an army is available in one of the channels.  ChannelID indicates which channel has the units.
void spawn(int channelID=-1)
{     
   aiEcho("Spawn firing, channelID = "+channelID);
   switch(channelID)
   {
   case 0:
      {
         checkSouthStart();
         break;
      }
   case 1:
      {
         checkEastStart();
         break;
      }
   case 2:
      {
         checkNorthStart();
         break;
      }
   }
}
*/


// Called by a trigger, to let AI know that the game has started
void wakeup(int parm=-1)
{
   xsDisableRule("spoofWakeup");       // No need for rule to fire, the trigger woke us up.
   aiEcho("Wakeup running at "+xsGetTime()/1000);
   xsEnableRule("checkNorthStart");
   xsEnableRule("checkEastStart");
   xsEnableRule("checkSouthStart");
   xsEnableRule("taskBuilders");
   //xsEnableRule("useCurse");  Disabled because Ian doesn't like it.  ;-)
   xsEnableRule("useRestoration");
   xsEnableRule("pollForMilitary");
}


int createDefendPlan(vector point = vector(-1,-1,-1))       // Make a defend plan gathering units at this point, return plan ID
{
   int planID = -1;
   int vilCount = 0;       // How many villagers in the neighborhood?
 
   int query=-1;           // Query to find the villagers, if any.

   query = kbUnitQueryCreate("Villagers");
   if (query < 0)
      return(-1);

   configQuery(query, cUnitTypeVillagerGreek, -1, cUnitStateAlive, cMyID, point, true, 30.0);
   kbUnitQueryResetResults(query);
   vilCount = kbUnitQueryExecute(query);


   int defendPlan =aiPlanCreate("Defend Plan "+timeString(), cPlanDefend);
   if (defendPlan >= 0)
   {
      aiPlanAddUnitType(defendPlan, cUnitTypeMilitary, 0, defendPlanSize, defendPlanSize);    // Unassigned mil units
      aiPlanSetDesiredPriority(defendPlan, 50);                       // Way low, below scouting and attack
      aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 50);
      aiPlanSetVariableBool(defendPlan, cDefendPlanPatrol, 0, false);
      aiPlanSetVariableFloat(defendPlan, cDefendPlanGatherDistance, 0, 5.0);
      aiPlanSetInitialPosition(defendPlan, point);
      aiPlanSetUnitStance(defendPlan, cUnitStanceDefensive);

      aiPlanSetVariableInt(defendPlan, cDefendPlanRefreshFrequency, 0, 5);
      aiEcho("Creating defend plan "+defendPlan+".");

      if (vilCount < 1) // No vills, just get units
      {
         if (aiRandInt(4) == 0)   // 1 in 4
         {
            aiEcho("  will defend bridge.");
            aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbSouthPass));
         }
         else
         {
            aiEcho("  will defend ram.");
            aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbGate));
         }
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);
      }
      else
      {                          // Escort the villagers
         aiEcho("  will escort "+vilCount+" villagers.");
         aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 20);    // ultra-close cover?
         aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, point);
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanDefendTargetID, vilCount, true);
         int i = 0;
         for (i=0; < vilCount)
         {
            aiPlanSetVariableInt(defendPlan, cDefendPlanDefendTargetID, i, kbUnitQueryGetResult(query, i)); // Add this vill to the list
         }
         aiEcho("Added "+vilCount+" villagers to defend list.");
         aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
         aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);
      }

      aiPlanSetActive(defendPlan); 
//    aiPlanSetNoMoreUnits(defendPlan, true);
      return(defendPlan);
   }
   else
      return(-1);
}

int checkForMilitary(vector point = vector(-1,-1,-1))
{
   return( getUnassignedUnitCount(point, 30.0, cMyID, cUnitTypeMilitary) );
}


void main()
{
   aiEcho("Starting Scn12p2.xs");
   kbSetTownLocation(kbGetBlockPosition(cbGate));
   aiSetAttackResponseDistance(20.0);

   //Calculate some areas.
   kbAreaCalculate(1200.0);

   aiRandSetSeed();

}

// *****************************************************************************
//
// RULES
//
// *****************************************************************************
rule bigBrother         // Look over the defend plan's shoulder, set it to not take new units as soon as it has its initial army.
   inactive 
   runImmediately
{
   static int startTime = -1;      // Used to set a time limit for this plan's initial staffing

   if (startTime == -1)
      startTime = xsGetTime();     // 30 second max
   else
   {
      if ( xsGetTime() > (startTime+10000) )     // Check time limit, 10 seconds max
      {
         aiEcho("  Time limit exceeded on defend plan "+currentDefendPlan);
         aiPlanSetNoMoreUnits( currentDefendPlan, true );
         xsDisableSelf();
         creatingDefendPlan = false;
         currentDefendPlan = -1;
         defendPlanSize = -1;
         startTime = -1;
         return;
      }
   }

   int actualSize = -1;
   actualSize = aiPlanGetNumberUnits(currentDefendPlan, cUnitTypeMilitary);
      
   if (actualSize >= defendPlanSize)   // we're done!
   {
      aiEcho("  Defend plan has "+actualSize+" units.");
      aiPlanSetNoMoreUnits( currentDefendPlan, true );
      xsDisableSelf();
      creatingDefendPlan = false;
      currentDefendPlan = -1;
      defendPlanSize = -1;
      startTime = -1;
      return;
   }

   // Otherwise, keep waiting
}



rule pollForMilitary       // Check all three spawn locations looking for unassigned units
   minInterval 5
   inactive
{
   if (creatingDefendPlan == true)
      return;     // Do not start new groups until current one is done

   defendPlanSize = checkForMilitary(kbGetBlockPosition(cbNorthStart));
   if (defendPlanSize > 0)
   {
      aiEcho("Found "+defendPlanSize+" units in the north tunnel.");
      creatingDefendPlan = true;    // Blocks createion of others until big brother clears it.
      currentDefendPlan = createDefendPlan(kbGetBlockPosition(cbNorthStart));
      xsEnableRule("bigBrother");
      return;
   }

   defendPlanSize = checkForMilitary(kbGetBlockPosition(cbEastStart));
   if (defendPlanSize > 0)
   {
      aiEcho("Found "+defendPlanSize+" units in the east tunnel.");
      creatingDefendPlan = true;    // Blocks createion of others until big brother clears it.
      currentDefendPlan = createDefendPlan(kbGetBlockPosition(cbEastStart));
      xsEnableRule("bigBrother");
      return;
   }

   defendPlanSize = checkForMilitary(kbGetBlockPosition(cbSouthStart));
   if (defendPlanSize > 0)
   {
      aiEcho("Found "+defendPlanSize+" units in the south tunnel.");
      creatingDefendPlan = true;    // Blocks createion of others until big brother clears it.
      currentDefendPlan = createDefendPlan(kbGetBlockPosition(cbSouthStart));
      xsEnableRule("bigBrother");
      return;
   }
}



rule useCurse 
   minInterval 5
   inactive
{
   if (xsGetTime() < 300000)
      return;  // Not before five minutes!

   // look for a group of 6 enemy military units, at the gate or the pass
   int targetUnit = -1;

   
   static int tempQuery = -1;
   if (tempQuery < 0)
   {  // Doesn't exist, set it up
      tempQuery = kbUnitQueryCreate("useCurseHome");
      if ( configQuery(tempQuery, cUnitTypeMilitary, -1, cUnitStateAlive, 1, kbGetBlockPosition(cbGate), true, 50) == false)
         return;
   }
   kbUnitQueryResetResults(tempQuery);
   int targetCount = kbUnitQueryExecute(tempQuery);  

   if (targetCount < 6)
   {
      vector pVec = kbGetBlockPosition(cbSouthPass);
      if (xsVectorGetX(pVec)>=0)
      {
         static int tempQuery2 = -1;
         if (tempQuery2 < 0)
         {  // Doesn't exist, set it up
            tempQuery2 = kbUnitQueryCreate("useCurseArmy");
            if ( configQuery(tempQuery2, cUnitTypeMilitary, -1, cUnitStateAlive, 1, pVec, true, 50) == false)
               return;
         }
         else
            kbUnitQuerySetPosition(tempQuery, pVec); // Because pVec changes as army moves
         kbUnitQueryResetResults(tempQuery2);
         targetCount = kbUnitQueryExecute(tempQuery2);  
         if (targetCount < 6)
            return;
         else
            targetUnit = kbUnitQueryGetResult(tempQuery2, targetCount/2);  // grab middle unit
      }
   } 
   else
      targetUnit = kbUnitQueryGetResult(tempQuery, targetCount/2);  // grab middle unit


   aiEcho("Using Curse at "+kbUnitGetPosition(targetUnit));
   if ( aiCastGodPowerAtPosition(cTechCurse, kbUnitGetPosition(targetUnit)) == true)
      xsDisableSelf();

}



rule useRestoration // Check gate area, use when there are >= 10 CP units and >=10 HP units in area
   minInterval 5
   inactive
{
   
   int targetUnit = -1;

   static int tempQuery = -1;
   if (tempQuery < 0)
   {  // Doesn't exist, set it up
      tempQuery = kbUnitQueryCreate("useRestoration1");     // Look for my units
      if ( configQuery(tempQuery, cUnitTypeMilitary, -1, cUnitStateAlive, 2, kbGetBlockPosition(cbGate), true, 50) == false)
         return;
   }
   kbUnitQueryResetResults(tempQuery);
   int targetCount = kbUnitQueryExecute(tempQuery); 
   if (targetCount < 10)
      return;     // Not enough, wait
   else
      targetUnit = kbUnitQueryGetResult(tempQuery, targetCount/2);  // grab middle unit

   

   static int tempQuery2 = -1;
   if (tempQuery2 < 0)
   {  // Doesn't exist, set it up
      tempQuery2 = kbUnitQueryCreate("useRestoration2");    // Look for HP units
      if ( configQuery(tempQuery2, cUnitTypeMilitary, -1, cUnitStateAlive, 1, kbGetBlockPosition(cbGate), true, 50) == false)
         return;
   }
   kbUnitQueryResetResults(tempQuery2);
   targetCount = kbUnitQueryExecute(tempQuery2); 
   if (targetCount < 10)
      return;




   aiEcho("Using Restoration at "+kbUnitGetPosition(targetUnit));
   if ( aiCastGodPowerAtPosition(cTechRestoration, kbUnitGetPosition(targetUnit)) == true)
      xsDisableSelf();
   else
      aiEcho("Restoration failed at "+kbUnitGetPosition(targetUnit));
}


rule taskBuilders
   inactive
   minInterval 10
{
   static int villQuery = -1;
   int villCount = -1;

   if (villQuery < 0) // need to define query
   {
      villQuery = kbUnitQueryCreate("checkBuilders");    // Look for HP units
      if ( configQuery(villQuery, cUnitTypeVillagerGreek, cActionIdle, cUnitStateAlive, 2) == false)
         return;
   }
   kbUnitQueryResetResults(villQuery);
   villCount = kbUnitQueryExecute(villQuery);

   if (villCount == 0)
      return;

   int vill = -1;
   for (i=0; < villCount)
   {
      vill = kbUnitQueryGetResult(villQuery, i);
      aiTaskUnitWork(vill, kbGetBlockID("312"));     // Task them to work on the ram
   }
}
