//==============================================================================
// Scn07p7: AI Scenario Script for scenario 7 player 2
//==============================================================================
/*
   AI owner:  Mike Kidd
   Scenario owner: Jeff Brown

   Overview:
   This CP occupies the east edge of the map.  His role is to maintain an economy,
   and use that to build a navy with which he will attempt to control the water.

   The economy consists of a fishing plan, farming, woodcutting, and gold mining.

   This CP will not age up (stays in 3rd age), will not use god powers, and will
   not research any upgrades.  It will maintain a gatherer and fishing population,
   and will train warships as quickly as it can, up to a hard limit that depends
   on difficulty level.

   7/31/2002:  Added a wakeup() function to make it start later.  Reduced starting
   vills to zero.  Changed attack logic to attack at start of time interval if 
   attack group size is >= 1/2 max.

*/

include "scn lib.xs";



// Cinematic blocks
const string cbCenter = "8052";
const string cbDock = "8053";
const string cbDefendPoint = "8516";
const string cbAttackGather = "8517";
const string cbWaypointLand = "8518";
const string cbWaypointWater = "8519";
const string cbIsland = "8520";
const string cbNorthBeach = "8521";
const string cbEastBeach = "8522";
const string cbSouthBeach = "8523";
const string cbP7TC = "3662";


int   maxVills = 5;        // Will scale with difficulty
int   maxFishBoats = 3;    // Including one to scout
int   reserveSize = 15;
int   armyTotal = 30;
float goldPercent = 0.30;
float woodPercent = 0.60;
float foodPercent = 0.1;

int   attackRouteNorth = -1;
int   attackRouteEast = -1;
int   attackRouteSouth = -1;
int   attackRouteIsland = -1;

int   maxWarships = 1;
int   navalMaintain = -1;  // Naval unit maintain plan
int   transportMaintain = -1;

int   gathererTypeID = -1;
int   fishGatherer = -1;

int   mainBase = -1;
float mainRadius = 60.0;

int   startTime = -1;    // Time of wakeup call
int   nextNavalAttack = 240000;      // Absolute limit on attack start
int   minNavalAttackInterval = 480000; 
int   maxNavalAttackInterval = 540000;  

int   nextLandAttack = 1200000;    // 20 minutes
int   landAttackInterval = 1200000;
int   totalArmySize = 15;
float landAttackSize = 2;
int   maxLandAttackSize = 6;
float armySizeMultiplier = 1.5;

int   mainlandAreaGroup = -1;
int   islandAreaGroup = -1;

int   defendPlan = -1;
int   reservePlan = -1;


void wakeup(int parm=-1)      // AI FUNC trigger to tell CP to start
{
   aiEcho("Wakeup firing at "+timeString());

   static bool alreadyRun = false;  // Prevents multiple calls from taking effect
   if (alreadyRun == true)
      return;
   alreadyRun = true;

   startTime = xsGetTime();
   nextNavalAttack = nextNavalAttack + startTime;
   nextLandAttack = nextLandAttack + startTime;

   // Create villager maintain plan
   createSimpleMaintainPlan(gathererTypeID, maxVills, true, mainBase);
   // Create warship maintain plan  cUnitTypeFishingShipGreek  cUnitTypeArcherShip
   navalMaintain = maintainUnit(cUnitTypeTrireme, (totalArmySize/3), kbGetBlockPosition(cbWaypointWater), 1);
   transportMaintain = maintainUnit(cUnitTypeTransportShipGreek, 2, kbGetBlockPosition(cbDock), 1);
   aiPlanSetDesiredPriority(transportMaintain, 80);
   aiPlanSetDesiredPriority(navalMaintain, 60);
   
   // Create toxote maintain plan
   maintainUnit(cUnitTypeToxotes, totalArmySize, kbGetBlockPosition(cbP7TC), mainBase);

   // Define attack routes
   attackRouteNorth = attackRoute("Attack Route North", cbWaypointLand, cbWaypointWater, cbNorthBeach);
   attackRouteEast = attackRoute("Attack Route East", cbWaypointLand, cbWaypointWater, cbEastBeach);
   attackRouteSouth = attackRoute("Attack Route South", cbWaypointLand, cbWaypointWater, cbSouthBeach);
   attackRouteIsland = attackRoute("Attack Route Island", cbWaypointLand, cbWaypointWater, cbIsland);

   // Init low-priority defend plan to manage spare units
   defendPlan =aiPlanCreate("Defend Plan", cPlanDefend);
   if (defendPlan >= 0)
   {
      aiPlanAddUnitType(defendPlan, cUnitTypeToxotes, 0, 200, 200);    // All unassigned mil units
      aiPlanSetDesiredPriority(defendPlan, 10);                       // Way low, below scouting and attack
      aiPlanSetVariableVector(defendPlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbP7TC));
      aiPlanSetVariableFloat(defendPlan, cDefendPlanEngageRange, 0, 40);

      aiPlanSetVariableFloat(defendPlan, cDefendPlanGatherDistance, 0, 15.0);
      aiPlanSetInitialPosition(defendPlan, kbGetBlockPosition(cbP7TC));
      aiPlanSetUnitStance(defendPlan, cUnitStanceDefensive);

      aiPlanSetVariableBool(defendPlan, cDefendPlanPatrol, 0, false);

      aiPlanSetVariableInt(defendPlan, cDefendPlanRefreshFrequency, 0, 5);
      aiPlanSetNumberVariableValues(defendPlan, cDefendPlanAttackTypeID, 2, true);
      aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
      aiPlanSetVariableInt(defendPlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);
      
      aiPlanSetActive(defendPlan); 
      aiEcho("Creating defend plan");
   }

   // Higher-priority defend plan to reserve units for final push
   reservePlan =aiPlanCreate("Reserve Plan", cPlanDefend);
   if (reservePlan >= 0)
   {
      aiPlanAddUnitType(reservePlan, cUnitTypeMilitary, 0, totalArmySize/3, totalArmySize/3);   
      aiPlanSetDesiredPriority(reservePlan, 30);                       // Higher than other defend plans
      aiPlanSetVariableVector(reservePlan, cDefendPlanDefendPoint, 0, kbGetBlockPosition(cbP7TC));
      aiPlanSetVariableFloat(reservePlan, cDefendPlanEngageRange, 0, 10);

      aiPlanSetVariableFloat(reservePlan, cDefendPlanGatherDistance, 0, 10.0);
      aiPlanSetInitialPosition(reservePlan, kbGetBlockPosition(cbP7TC));
      aiPlanSetUnitStance(reservePlan, cUnitStanceDefensive);

      aiPlanSetVariableBool(reservePlan, cDefendPlanPatrol, 0, false);

      aiPlanSetVariableInt(reservePlan, cDefendPlanRefreshFrequency, 0, 5);
      aiPlanSetNumberVariableValues(reservePlan, cDefendPlanAttackTypeID, 2, true);
      aiPlanSetVariableInt(reservePlan, cDefendPlanAttackTypeID, 0, cUnitTypeUnit);
      aiPlanSetVariableInt(reservePlan, cDefendPlanAttackTypeID, 1, cUnitTypeBuilding);
      
      aiPlanSetActive(reservePlan); 
      aiEcho("Creating reserve defend plan");
   }


   xsEnableRule("navalAttackGenerator");
   xsEnableRule("landAttackGenerator");
}



void initMainBase()
{
   // Nuke bases, add one base to rule them all
   kbBaseDestroyAll(cMyID);

   mainBase = kbBaseCreate(cMyID, "Base "+kbBaseGetNextID(), kbGetBlockPosition(cbCenter), mainRadius);
   if (mainBase < 0)
      aiEcho("***** Main base creation failed. *****");

   vector baseFront=xsVectorNormalize(kbGetMapCenter()-kbGetBlockPosition(cbCenter));     // Set front
   kbBaseSetFrontVector(cMyID, mainBase, baseFront);                 
   kbBaseSetMaximumResourceDistance(cMyID, mainBase, mainRadius+20.0);                    // Gather up to 20m beyond base perimeter
   kbBaseSetMain(cMyID, mainBase, true);     // Make this the main base

   // Add the buildings
   int buildingQuery = -1;
   int count = 0;
   buildingQuery = kbUnitQueryCreate("Building Query");     // All buildings in the base
   configQuery(buildingQuery, cUnitTypeBuilding, -1, cUnitStateAliveOrBuilding, cMyID, kbGetBlockPosition(cbCenter), false, mainRadius);
   kbUnitQueryResetResults(buildingQuery);
   count = kbUnitQueryExecute(buildingQuery);

   int i = 0;
   int buildingID = -1;
   for (i=0; < count)
   {
      buildingID = kbUnitQueryGetResult(buildingQuery, i);
      // Add it to the base
      kbBaseAddUnit( cMyID, mainBase, buildingID );
   }
}


void initEcon()
{
   aiSetAttackResponseDistance(20.0);   // Kill escrows
   kbEscrowSetPercentage( cEconomyEscrowID, cAllResources, 0.0);
   kbEscrowSetPercentage( cMilitaryEscrowID, cAllResources, 0.0);
   kbEscrowAllocateCurrentResources();

   aiSetAutoGatherEscrowID(cRootEscrowID);
   aiSetAutoFarmEscrowID(cRootEscrowID);
   gathererTypeID = kbTechTreeGetUnitIDTypeByFunctionIndex(cUnitFunctionGatherer,0);

   
   int herdPlanID=aiPlanCreate("GatherHerdable Plan", cPlanHerd);
   if (herdPlanID >= 0)
   {
      aiPlanAddUnitType(herdPlanID, cUnitTypeHerdable, 0, 100, 100);
      aiPlanSetVariableInt(herdPlanID, cHerdPlanBuildingTypeID, 0, cUnitTypeSettlementLevel1);
      aiPlanSetActive(herdPlanID);
   }

   aiSetResourceGathererPercentageWeight(cRGPScript, 1);
   aiSetResourceGathererPercentageWeight(cRGPCost, 0);

   kbSetAICostWeight(cResourceFood, 1.0);
   kbSetAICostWeight(cResourceWood, 0.7);
   kbSetAICostWeight(cResourceGold, 0.8);
   kbSetAICostWeight(cResourceFavor, 7.0);

   aiSetResourceGathererPercentage(cResourceFood, foodPercent, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceWood, woodPercent, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceGold, goldPercent, false, cRGPScript);
   aiSetResourceGathererPercentage(cResourceFavor, 0.0, false, cRGPScript);
   aiNormalizeResourceGathererPercentages(cRGPScript);

   //bool aiSetResourceBreakdown( int resourceTypeID, int resourceSubTypeID, int numberPlans, int planPriority, float percentage, int baseID )
//	aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeEasy, numFoodEasyPlans, 50, 1.0, gMainBaseID);
//   aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeHuntAggressive, numFoodHuntAggressivePlans, 100, 1.0, gMainBaseID);
   aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeFish, 1, 50, 1.0, mainBase);
   aiSetResourceBreakdown(cResourceFood, cAIResourceSubTypeFarm, 1, 50, 1.0, mainBase);
   aiSetResourceBreakdown(cResourceWood, cAIResourceSubTypeEasy, 1, 50, 1.0, mainBase);
	aiSetResourceBreakdown(cResourceGold, cAIResourceSubTypeEasy, 1, 50, 1.0, mainBase);
//   aiSetResourceBreakdown(cResourceFavor, cAIResourceSubTypeEasy, numFavorPlans, 50, 1.0, gMainBaseID);
}



void attack()
{

   int   attackID=aiPlanCreate("Boat Attack "+timeString()+"  ", cPlanAttack);
   if (attackID < 0)
   {
      return;
   }

   if (aiPlanSetVariableInt(attackID, cAttackPlanPlayerID, 0, 1) == false)
   {
      return;
   }

   if (aiPlanSetNumberVariableValues(attackID, cAttackPlanTargetTypeID, 2, true) == false)
   {
      return;
   }

   // add "unit" and "building" to attack list
   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 0, cUnitTypeUnit);
   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 1, cUnitTypeBuilding);



   aiPlanSetVariableVector(attackID, cAttackPlanGatherPoint, 0, kbGetBlockPosition(cbWaypointWater));
   aiPlanSetVariableFloat(attackID, cAttackPlanGatherDistance, 0, 30.0);

   aiPlanAddUnitType(attackID, cUnitTypeTrireme, 1, maxWarships, maxWarships);


   aiPlanSetInitialPosition(attackID, kbGetBlockPosition(cbWaypointWater));
   aiPlanSetRequiresAllNeedUnits(attackID, true);
   aiPlanSetActive(attackID);
   aiEcho("Activating attack plan "+attackID);
//   if (lastAttackPlan >= 0)
//      aiPlanDestroy(lastAttackPlan);   // free up last set of units?
//   lastAttackPlan = attackID; // update the global var
}


void landAttack()
{
   static int islandQuery = -1;
   aiEcho("Doing land attack with "+landAttackSize+" units.");

   if (islandQuery < 0)
   {
      islandQuery = kbUnitQueryCreate("Island query");
      configQuery(islandQuery, cUnitTypeUnit, -1, cUnitStateAlive, 1, kbGetBlockPosition(cbIsland), false, 20);   // P1 units on island
   }
   kbUnitQueryResetResults(islandQuery);
   
   bool islandValid = false;
   if (kbUnitQueryExecute(islandQuery) > 0)
   {
      aiEcho("Targets exist on island");
      islandValid = true;
   }
   else
   {
      islandValid = false;
      aiEcho("No targets on island");
   }

   int randVal = -1;
   if (islandValid == true)
      randVal = aiRandInt(4);       // Used for picking attack route, destination (below)
   else
      randVal = aiRandInt(3);

   int   attackID=aiPlanCreate("Land Attack on target "+randVal+" at "+timeString()+"  ", cPlanAttack);
   if (attackID < 0)
   {
      return;
   }
   if (aiPlanSetVariableInt(attackID, cAttackPlanPlayerID, 0, 1) == false)
   {
      return;
   }
   if (aiPlanSetNumberVariableValues(attackID, cAttackPlanTargetTypeID, 1, true) == false)
   {
      return;
   }
   // add "unit" and "building" to attack list
   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 0, cUnitTypeUnit);
//   aiPlanSetVariableInt(attackID, cAttackPlanTargetTypeID, 1, cUnitTypeBuilding);

   aiPlanSetVariableVector(attackID, cAttackPlanGatherPoint, 0, kbGetBlockPosition(cbWaypointLand));
   aiPlanSetVariableFloat(attackID, cAttackPlanGatherDistance, 0, 30.0);

   aiPlanAddUnitType(attackID, cUnitTypeToxotes, 1, landAttackSize, landAttackSize);

   aiPlanSetInitialPosition(attackID, kbGetBlockPosition(cbWaypointLand));
   aiPlanSetUnitStance(attackID, cUnitStanceAggressive);
   aiPlanSetRequiresAllNeedUnits(attackID, true);


   switch(randVal)   // Pick an attack route, continent destination.
   {
   case 0:        // North
      {
         // Specify continent 
         aiPlanSetNumberVariableValues( attackID, cAttackPlanTargetAreaGroups,  1, true);  
         aiPlanSetVariableInt(attackID, cAttackPlanTargetAreaGroups, 0, kbAreaGroupGetIDByPosition(kbGetBlockPosition(cbNorthBeach)));
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, attackRouteNorth);
         aiEcho("Attacking north beach.");
         break;
      }
   case 1:        // East
      {
         // Specify continent 
         aiPlanSetNumberVariableValues( attackID, cAttackPlanTargetAreaGroups,  1, true);  
         aiPlanSetVariableInt(attackID, cAttackPlanTargetAreaGroups, 0, kbAreaGroupGetIDByPosition(kbGetBlockPosition(cbNorthBeach)));
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, attackRouteEast);
         aiEcho("Attacking east beach.");
         break;
      }
   case 2:        // South
      {
         // Specify continent 
         aiPlanSetNumberVariableValues( attackID, cAttackPlanTargetAreaGroups,  1, true);  
         aiPlanSetVariableInt(attackID, cAttackPlanTargetAreaGroups, 0, kbAreaGroupGetIDByPosition(kbGetBlockPosition(cbNorthBeach)));
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, attackRouteSouth);
         aiEcho("Attacking south beach.");
         break;
      }
   case 3:        // Island
      {
         // Specify continent 
         aiPlanSetNumberVariableValues( attackID, cAttackPlanTargetAreaGroups,  1, true);  
         aiPlanSetVariableInt(attackID, cAttackPlanTargetAreaGroups, 0, kbAreaGroupGetIDByPosition(kbGetBlockPosition(cbIsland)));
         aiPlanSetVariableInt(attackID, cAttackPlanAttackRouteID, 0, attackRouteIsland);
         aiEcho("Attacking island.");
         break;
      }
   }

   aiPlanSetActive(attackID);
   aiEcho("Activating attack plan "+attackID);
}


void main()
{
   aiEcho("Starting Scn07p7.xs");
   aiRandSetSeed();
   kbSetTownLocation(kbGetBlockPosition(cbCenter));
   //Calculate some areas.
   kbAreaCalculate(1200.0);


   mainlandAreaGroup = kbAreaGroupGetIDByPosition(kbGetBlockPosition(cbNorthBeach));
   islandAreaGroup = kbAreaGroupGetIDByPosition(kbGetBlockPosition(cbIsland));

   switch(aiGetWorldDifficulty())
   {
   case 0:
      {
         maxWarships = 1;
         maxVills = 5;
         nextNavalAttack = 10*60*1000;
         minNavalAttackInterval = 6*60*1000;
         maxNavalAttackInterval = 2 * minNavalAttackInterval;
         nextLandAttack = 20*60*1000;
         landAttackInterval = 20*60*1000;
         landAttackSize = 2.0;
         armySizeMultiplier = 1.5;
         maxLandAttackSize = 6;
         totalArmySize = 15;
         break;
      }
   case 1:
      {
         maxWarships = 2;
         maxVills = 6;
         nextNavalAttack = 360000;      // Absolute limit on attack start
         minNavalAttackInterval = 240000; 
         maxNavalAttackInterval = 480000;  
         nextLandAttack = 15*60*1000;
         landAttackInterval = 13*60*1000;
         landAttackSize = 3.0;
         armySizeMultiplier = 1.5;
         maxLandAttackSize = 8;
         totalArmySize = 20;
         break;
      }
   case 2:
      {
         maxWarships = 4;
         maxVills = 10;
         nextNavalAttack = 360000;      // Absolute limit on attack start
         minNavalAttackInterval = 180000; 
         maxNavalAttackInterval = 300000;  
         nextLandAttack = 13*60*1000;
         landAttackInterval = 10*60*1000;
         landAttackSize = 5.0;
         armySizeMultiplier = 1.5;
         maxLandAttackSize = 12;
         totalArmySize = 30;
         break;
      }
   case 3:
      {
         maxWarships = 8;
         maxVills = 20;
         nextNavalAttack = 240000;      // Absolute limit on attack start
         minNavalAttackInterval = 120000; 
         maxNavalAttackInterval = 240000;  
         nextLandAttack = 8*60*1000;
         landAttackInterval = 6*60*1000;
         landAttackSize = 8.0;
         armySizeMultiplier = 1.4;
         maxLandAttackSize = 20;
         totalArmySize = 40;
         break;
      }
   }

   initMainBase();    // Destroy all auto-bases, make one manual base for everything
   initEcon();

}



rule killNavalActivity
   minInterval 5
   active
{
   if (aiGetWorldDifficulty() > 1)  
   {
      xsDisableSelf();
      return;  // Quit if hard or nightmare
   }

   if (kbUnitCount(cMyID, cUnitTypeDock, cUnitStateAlive) < 1)
   {
      aiEcho("Dock destroyed, stopping naval activity.");
      aiPlanDestroy(navalMaintain);
      aiPlanDestroy(transportMaintain);
      xsDisableRule("navalAttackGenerator");
      xsDisableRule("landAttackGenerator");
      xsDisableSelf();
   }
}

rule navalAttackGenerator
   minInterval 15
   inactive
{
   if (xsGetTime() < nextNavalAttack)
      return;

   int warships = 0;
   warships = kbUnitCount(cMyID, cUnitTypeTrireme, cUnitStateAlive);

   if (warships < 1)
      return;

   // If we're under time limit,  and below max/2, do nothing.
   if (xsGetTime() < (nextNavalAttack + (maxNavalAttackInterval-minNavalAttackInterval) ))
      if (warships < (maxWarships/2))
         return;

   // If we're here, we're either out of time, or at max/2 ship pop and at an OK time.
   attack();
   nextNavalAttack = xsGetTime() + minNavalAttackInterval;
   aiEcho("Doing boat attack with "+warships+" boats.");

}

rule landAttackGenerator
   minInterval 13
   inactive
{
   if (xsGetTime() < nextLandAttack)
      return;

   landAttack();

   nextLandAttack = xsGetTime() + landAttackInterval;
   landAttackSize = landAttackSize * armySizeMultiplier;
   if (landAttackSize > maxLandAttackSize)
      landAttackSize = maxLandAttackSize;

}
//==============================================================================
// RULE: fishing
//==============================================================================
rule fishing
   minInterval 30
   active
{

	//-- Get the closest water area.  if there isn't one, we can't fish.
	static int areaID = -1;
	if(areaID == -1)
		areaID = kbAreaGetClosetArea(kbGetBlockPosition(cbCenter), cAreaTypeWater);

//	if( kbSetupForResource(mainBase, cResourceWood, 25.0, 600) == false)
//      return;
   
	//-- get our fish gatherer.
	fishGatherer = kbTechTreeGetUnitIDTypeByFunctionIndex(cUnitFunctionFish,0);

	//-- Create the fish plan.
	int fishPlanID=aiPlanCreate("FishPlan", cPlanFish);
	if (fishPlanID >= 0)
	{
		aiEcho("Starting up the fishing plan.  Will fish when I find fish.");
      aiPlanSetDesiredPriority(fishPlanID, 70);
		aiPlanSetVariableVector(fishPlanID, cFishPlanLandPoint, 0, kbGetBlockPosition(cbCenter));
		//-- If you don't explicitly set the water point, the plan will find one for you.
		aiPlanSetVariableBool(fishPlanID, cFishPlanAutoTrainBoats, 0, false);   // I'm going to have a  maintain plan for fishing + scouting combined
		aiPlanSetEscrowID(fishPlanID, cRootEscrowID);

		aiPlanAddUnitType(fishPlanID, fishGatherer, 1, maxFishBoats-1, maxFishBoats-1);
		aiPlanSetActive(fishPlanID);
	}

/*
   //-- Build a dock in water, so we can scout.
   int buildDock = aiPlanCreate("BuildDock", cPlanBuild);
   if(buildDock >= 0)
   {
      aiEcho("Building dock for scouting.");
      //BP Type and Priority.
      aiPlanSetVariableInt(buildDock, cBuildPlanBuildingTypeID, 0, cUnitTypeDock);
      aiPlanSetDesiredPriority(buildDock, 100);
      aiPlanSetVariableVector(buildDock, cBuildPlanDockPlacementPoint, 0, kbBaseGetLocation(cMyID, gMainBaseID));
      aiPlanSetVariableVector(buildDock, cBuildPlanDockPlacementPoint, 1, kbAreaGetCenter(areaID));
      aiPlanAddUnitType(buildDock, kbTechTreeGetUnitIDTypeByFunctionIndex(cUnitFunctionBuilder, 0), 1, 1, 1);
      aiPlanSetEscrowID(buildDock, cEconomyEscrowID);
      aiPlanSetActive(buildDock);
   }
*/

   createSimpleMaintainPlan(fishGatherer, maxFishBoats, true, mainBase);

   // Add a fish boat plan
   int exploreWaterID = aiPlanCreate("Water Explore", cPlanExplore);
   if(exploreWaterID >= 0)
   {

      aiPlanSetVariableFloat( exploreWaterID, cExplorePlanLOSMultiplier,  0, 4.0 );
      aiPlanAddUnitType(exploreWaterID, fishGatherer, 1, 1, 1);
      aiPlanSetDesiredPriority(exploreWaterID, 90);
      aiPlanSetActive(exploreWaterID);
   }

	xsDisableSelf();
}


rule scout
   active
{
   // just set up an explore plan
   int exploreID = aiPlanCreate("Explore", cPlanExplore);
   if(exploreID >= 0)
   {
      //aiPlanAddVariableFloat( exploreID, cExplorePlanLOSMultiplier, "LOS Multiplier", 1);
      aiPlanSetVariableFloat( exploreID, cExplorePlanLOSMultiplier,  0, 4.0 );
      aiPlanAddUnitType(exploreID, cUnitTypeScout, 1, 1, 1);
      aiPlanSetDesiredPriority(exploreID, 90);
      aiPlanSetActive(exploreID);
   }

   xsDisableSelf();
}