//==============================================================================
// Scn05p2: AI Scenario Script for p2
//==============================================================================
/*
   AI owner:  Dave Leary
   Scenario owner: Dave Leary
*/
//==============================================================================
// Set Town Location
//==============================================================================
void setTownLocation(void)
{
   //Look for the "Town Location" marker.
   kbSetTownLocation(kbGetBlockPosition("2443"));
}

//==============================================================================
// miscStartup
//==============================================================================
void miscStartup(void)
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

    //Startup message(s).
   aiEcho("");
   aiEcho("");
   aiEcho("Scn05P2 AI Start, filename='"+cFilename+"'.");
   //Spit out the map size.
   aiEcho("  Map size is ("+kbGetMapXSize()+", "+kbGetMapZSize()+").");
   //Cheat like a bastard.  Once only, though.
   kbLookAtAllUnitsOnMap();
   //Calculate some areas.
   kbAreaCalculate(1200.0);
   //Set our town location.
   setTownLocation();
	//Reset random seed
	aiRandSetSeed();
   //Allocate all resources to the root escrow.
   kbEscrowAllocateCurrentResources();
}

//=====================================================================================
// When Kamos arrives on his little hilltop, create a defend plan that keeps him up
// there in one spot.
//=====================================================================================
void kamosArrives(int scriptCall = -1)
{
	vector defendLoc=kbGetBlockPosition("2443");

	int defendPlanID=aiPlanCreate("Kamos Defense", cPlanDefend);
   if (defendPlanID >= 0)
   {
      //Add the unit(s).
      aiPlanAddUnitType(defendPlanID, cUnitTypeKamos, 1, 1, 1);
		
      //Setup the vars.
      aiPlanSetDesiredPriority(defendPlanID, 90);
      aiPlanSetVariableVector(defendPlanID, cDefendPlanDefendPoint, 0, defendLoc);
		aiPlanSetInitialPosition(defendPlanID, defendLoc);
		aiPlanSetVariableFloat(defendPlanID, cDefendPlanGatherDistance, 0, 20.0);
      aiPlanSetVariableFloat(defendPlanID, cDefendPlanEngageRange, 0, 5);
		aiPlanSetUnitStance(defendPlanID, cUnitStanceDefensive);
		aiPlanSetAllowUnderAttackResponse(defendPlanID, false);
      aiPlanSetActive(defendPlanID);
	}
}

//==============================================================================
// MAIN
//==============================================================================
void main(void)
{
   //Startup.
   miscStartup();
}
