//==============================================================================
// Scn04p5: AI Scenario Script for scenario 4 player 5
//==============================================================================
/*
   AI owner:  Dave Leary
   Scenario owner: Dave Leary

	This AI is based on scn04p2.xs, and is used to handle the final "big attack"
	in scenario 4.  See scn04p2 for difficulty level details.

*/
//==============================================================================
// Set Town Location
//==============================================================================
void setTownLocation(void)
{
   //Look for the "Town Location" marker.
   kbSetTownLocation(kbGetBlockPosition("3539"));
}

//==============================================================================
// miscStartup
//==============================================================================
void miscStartup(void)
{
	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

   //Startup message(s).
   aiEcho("");
   aiEcho("");
   aiEcho("Scn04P2 AI Start, filename='"+cFilename+"'.");
	aiEcho("Difficulty Level="+difflevel+".");
   //Spit out the map size.
   aiEcho("  Map size is ("+kbGetMapXSize()+", "+kbGetMapZSize()+").");
   //Cheat like a bastard.  Once only, though.
   kbLookAtAllUnitsOnMap();
   //Calculate some areas.
   kbAreaCalculate(1200.0);
   //Set our town location.
   setTownLocation();
	//Reset random seed
	aiRandSetSeed();
   //Allocate all resources to the root escrow.
   kbEscrowAllocateCurrentResources();
}

//==============================================================================
//==============================================================================
// Attack stuff.
//==============================================================================
//==============================================================================
//Shared variables.

int attackerUnitTypeIDSoldier=cUnitTypeAxeman;
int attackerUnitTypeIDTransport=cUnitTypePirateShip;

//=========================================================================================
// Kidd's cool configQuery function: used to create attack routes, etc.  Oooh, lovin' that!
//=========================================================================================
bool configQuery( int queryID = -1, int unitType = -1, int action = -1, int state = -1, int player = -1, vector center = vector(-1,-1,-1), bool sort = false, float radius = -1 )
{
   if ( queryID == -1)
   {
      return(false);
   }

   if (player != -1)
      kbUnitQuerySetPlayerID(queryID, player);
   
   if (unitType != -1)
      kbUnitQuerySetUnitType(queryID, unitType);

   if (action != -1)
      kbUnitQuerySetActionType(queryID, action);

   if (state != -1)
      kbUnitQuerySetState(queryID, state);

   if (center != vector(-1,-1,-1))
   {
      kbUnitQuerySetPosition(queryID, center);
      if (sort == true)
         kbUnitQuerySetAscendingSort(queryID, true);
      if (radius != -1)
         kbUnitQuerySetMaximumDistance(queryID, radius);
   }
   return(true);
}

//=====================================================================================
// finalAttack.  This is called from the scenario with an AI Func effect
//=====================================================================================
void finalAttack(int whichAttack = -1)
{
	int transportPlanID=aiPlanCreate("Transport Group", cPlanTransport);
	// "whichTransport" adds a specific transport to the plans.  Victory conditions, chats, etc.
	// are tied to the concept of the main transport getting whacked.
	int whichTransport=-1;

	// Difficulty Level check.
	int difflevel=-1;		
	difflevel=aiGetWorldDifficulty();

	vector gatherPoint=kbGetBlockPosition("3535");
	vector targetPoint=kbGetBlockPosition("2642");
	vector initialPosition=kbGetBlockPosition("3539");

	int baseID = kbBaseCreate( 5, "mainBase", initialPosition, 50.0);
	
	// Same unit types in each transport.
	aiPlanAddUnitType(transportPlanID, cUnitTypePirateShip, 1, 1, 1);
	aiPlanAddUnitType(transportPlanID, cUnitTypeSpearman, 8, 8, 8);
	aiPlanAddUnitType(transportPlanID, cUnitTypeAnubite, 2, 2, 2);
	
	if (transportPlanID >= 0)
   {
		aiEcho("*** BOAT FROM FINAL ATTACK EN ROUTE ***");
		switch(whichAttack)
		{	
			case 0:
			{
				gatherPoint=kbGetBlockPosition("3535");
				targetPoint=kbGetBlockPosition("3541");

				whichTransport = kbGetBlockID("3531");

				aiPlanSetVariableInt(transportPlanID, cTransportPlanTransportTypeID, 0, cUnitTypePirateShip);
				aiPlanSetVariableInt(transportPlanID, cTransportPlanTransportID, 0, whichTransport);
				break;
			}

			case 1:
			{
				
				gatherPoint=kbGetBlockPosition("3536");
				targetPoint=kbGetBlockPosition("3540");

				whichTransport = kbGetBlockID("3532");

				aiPlanSetVariableInt(transportPlanID, cTransportPlanTransportTypeID, 0, cUnitTypePirateShip);
				aiPlanSetVariableInt(transportPlanID, cTransportPlanTransportID, 0, whichTransport);
				break;
			}

			case 2:
			{
				gatherPoint=kbGetBlockPosition("3537");
				targetPoint=kbGetBlockPosition("3542");

				whichTransport = kbGetBlockID("3533");

				aiPlanSetVariableInt(transportPlanID, cTransportPlanTransportTypeID, 0, cUnitTypePirateShip);
				aiPlanSetVariableInt(transportPlanID, cTransportPlanTransportID, 0, whichTransport);
				break;
			}

			case 3:
			{
				gatherPoint=kbGetBlockPosition("3538");
				targetPoint=kbGetBlockPosition("3543");

				whichTransport = kbGetBlockID("3534");
				
				aiPlanSetVariableInt(transportPlanID, cTransportPlanTransportTypeID, 0, cUnitTypePirateShip);
				aiPlanSetVariableInt(transportPlanID, cTransportPlanTransportID, 0, whichTransport);
				break;
			}
		}

		aiPlanSetVariableBool(transportPlanID, cTransportPlanMaximizeXportMovement, 0, true);
		aiPlanSetVariableVector(transportPlanID, cTransportPlanGatherPoint, 0, gatherPoint);
      aiPlanSetVariableVector(transportPlanID, cTransportPlanTargetPoint, 0, targetPoint);

		// Setting the base.
		aiPlanSetBaseID( transportPlanID, baseID );

		// Don't return when finished.
		aiPlanSetVariableBool(transportPlanID, cTransportPlanReturnWhenDone, 0, false);

		// Initial Position
		aiPlanSetInitialPosition( transportPlanID, initialPosition );
			
		aiPlanAddUnit(transportPlanID, whichTransport);
      aiPlanSetActive(transportPlanID);
   }
}


//=====================================================================================
// responseRangeSet
//=====================================================================================
void responseRangeSet(int parameter = -1)
{
	// Drop the AI attack response distance to hopefully get guys running
	// away bett4r.
	aiSetAttackResponseDistance(0.0);
}

//==============================================================================
// MAIN.
//==============================================================================
void main(void)
{
   //Startup.
   miscStartup();
}
