--require "fonthelper"

local assets =
{
	Asset("ANIM", "anim/ds_pig_basic.zip"),
	Asset("ANIM", "anim/ds_pig_actions.zip"),
	Asset("ANIM", "anim/ds_pig_attacks.zip"),
	Asset("ANIM", "anim/pig_build.zip"),
	Asset("ANIM", "anim/pigspotted_build.zip"),
	Asset("ANIM", "anim/pig_guard_build.zip"),
	Asset("ANIM", "anim/werepig_build.zip"),
	Asset("ANIM", "anim/werepig_basic.zip"),
	Asset("ANIM", "anim/werepig_actions.zip"),
	Asset("SOUND", "sound/pig.fsb"),
}

local prefabs =
{
    "meat",
    "monstermeat",
    "poop",
    "tophat",
    "strawhat",
    "pigskin",
}

local MAX_TARGET_SHARES = 5
local SHARE_TARGET_DIST = 30
PIG_DISCOVERER_DEFEND_DIST=10--守护猪王和家
PIG_DISCOVERER_TARGET_DIST=6--发现身边目标，进行攻击距离
PIG_DISCOVERER_HEALTH=TUNING.PIG_GUARD_HEALTH+600
PIG_DISCOVERER_DAMAGE=TUNING.PIG_GUARD_DAMAGE+33
PIG_DISCOVERER_ATTACK_PERIOD=TUNING.PIG_GUARD_ATTACK_PERIOD
PIG_DISCOVERER_RUN_SPEED=TUNING.PIG_RUN_SPEED+1
PIG_DISCOVERER_WALK_SPEED=TUNING.PIG_WALK_SPEED+1

local function ontalk(inst, script)
	inst.SoundEmitter:PlaySound("dontstarve/pig/grunt")
end

local function OnAttacked(inst, data)
    local attacker = data.attacker

    inst.components.combat:SetTarget(attacker)

    if inst:HasTag("guard") then
            inst.components.combat:ShareTarget(attacker, SHARE_TARGET_DIST, function(dude) return dude:HasTag("pig") and (dude:HasTag("guard") or not attacker:HasTag("pig")) end, MAX_TARGET_SHARES)
    else
        if not (attacker:HasTag("pig") and attacker:HasTag("guard") ) then
            inst.components.combat:ShareTarget(attacker, SHARE_TARGET_DIST, function(dude) return dude:HasTag("pig") and not dude:HasTag("werepig") end, MAX_TARGET_SHARES)
        end
    end
end

local builds = {"pig_build", "pigspotted_build"}
local guardbuilds = {"pig_guard_build"}

local function GuardRetargetFn(inst)
    local home = inst.components.homeseeker and inst.components.homeseeker.home
    local defenseTarget = FindEntity(inst, PIG_DISCOVERER_DEFEND_DIST, function(guy) return guy:HasTag("king") end)
    if not defenseTarget and home and inst:GetDistanceSqToInst(home) < PIG_DISCOVERER_DEFEND_DIST*PIG_DISCOVERER_DEFEND_DIST then
        defenseTarget = home
    end
    if not defenseTarget then
        defenseTarget = inst
    end
    local invader = FindEntity(defenseTarget or inst, PIG_DISCOVERER_TARGET_DIST, function(guy)
        return guy:HasTag("character") and not guy:HasTag("guard") and  not guy:HasTag("pig")
    end)
    if not defenseTarget.happy then
        if invader
           and not (defenseTarget.components.trader and defenseTarget.components.trader:IsTryingToTradeWithMe(invader) )
           and not (inst.components.trader and inst.components.trader:IsTryingToTradeWithMe(invader) ) then
            return invader
        end
        if not GetClock():IsDay() and home and home.components.burnable and home.components.burnable:IsBurning() then
            local lightThief = FindEntity(home, home.components.burnable:GetLargestLightRadius(), function(guy)
                return guy:HasTag("player")
                       and guy.LightWatcher:IsInLight()
                       and not (defenseTarget.components.trader and defenseTarget.components.trader:IsTryingToTradeWithMe(guy) ) 
                       and not (inst.components.trader and inst.components.trader:IsTryingToTradeWithMe(guy) ) 
            end)
            if lightThief then
                return lightThief
            end
        end
    end
    return FindEntity(defenseTarget, PIG_DISCOVERER_DEFEND_DIST, function(guy)
        return guy:HasTag("monster")
    end)
end

local function GuardKeepTargetFn(inst, target)
    --[[
    local home = inst.components.homeseeker and inst.components.homeseeker.home
    if home then
        local defendDist = TUNING.PIG_DISCOVERER_DEFEND_DIST
        if not GetClock():IsDay() and home.components.burnable and home.components.burnable:IsBurning() then
            defendDist = home.components.burnable:GetLargestLightRadius()
        end
        return home:GetDistanceSqToInst(target) < defendDist*defendDist
               and home:GetDistanceSqToInst(inst) < defendDist*defendDist
    end
    ]]
    return inst.components.combat:CanTarget(target)     
           and not (target.sg and target.sg:HasStateTag("transform") )
end

local function DiscoveShouldSleep(inst)
    return false
end

local function DiscovererShouldWake(inst)
    return true
end

local function DiscoverRemove(inst)
    inst:Remove()
end

local function SetDisPig(inst)
    inst:AddTag("guard")
    inst:AddTag("discoverer")
    local brain = require "brains/discovererbrain"
    inst:SetBrain(brain)
    inst:SetStateGraph("SGdiscoverer")
	inst.AnimState:SetBuild(inst.build)
    
    inst.components.sleeper:SetResistance(3)
    inst.components.health:SetMaxHealth(PIG_DISCOVERER_HEALTH)
    inst.components.combat:SetDefaultDamage(PIG_DISCOVERER_DAMAGE)
    inst.components.combat:SetAttackPeriod(PIG_DISCOVERER_ATTACK_PERIOD)
    inst.components.combat:SetKeepTargetFunction(GuardKeepTargetFn)
    --攻击范围内的敌人
    inst.components.combat:SetRetargetFunction(1, GuardRetargetFn)
    inst.components.combat:SetTarget(nil)
    inst.components.locomotor.runspeed = PIG_DISCOVERER_RUN_SPEED
    inst.components.locomotor.walkspeed = PIG_DISCOVERER_WALK_SPEED
    
    inst.components.sleeper:SetSleepTest(DiscoveShouldSleep)
    inst.components.sleeper:SetWakeTest(DiscovererShouldWake)
    
    inst.components.lootdropper:SetLoot({})
    inst.components.lootdropper:AddRandomLoot("meat",3)
    inst.components.lootdropper:AddRandomLoot("pigskin",1)
    inst.components.lootdropper.numrandomloot = 1

    
    --inst.components.trader:Enable()
    --inst.Label:Enable(true)
    inst.components.talker:StopIgnoringAll()
    inst.components.follower:SetLeader(nil)
end

local function OnDeath(inst, data)
    local gravestone=SpawnPrefab("gravestone")
    gravestone.Transform:SetPosition(inst.Transform:GetWorldPosition())
end 

local function common()
    --print ("discoverer")
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 1.5, .75 )
    inst.Transform:SetFourFaced()

    inst.entity:AddLightWatcher()
    --inst.entity:AddLabel()

    MakeCharacterPhysics(inst, 50, .5)
    
    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.runspeed = PIG_DISCOVERER_RUN_SPEED --5
    inst.components.locomotor.walkspeed = PIG_DISCOVERER_WALK_SPEED --3

    inst:AddTag("character")
    inst:AddTag("pig")
    inst:AddTag("scarytoprey")
    anim:SetBank("pigman")
    anim:PlayAnimation("idle_loop")

    ------------------------------------------
    inst:AddComponent("eater")
    inst.components.eater:SetOmnivore()
    inst.components.eater:SetVegetarian()
    inst.components.eater:SetCarnivore()
    ------------------------------------------
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "pig_torso"

    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst:AddComponent("named")
    inst.components.named.possiblenames = STRINGS.PIGNAMES
    inst.components.named:PickNewName()
    
    ------------------------------------------
    inst:AddComponent("follower")
    inst.components.follower.maxfollowtime = TUNING.PIG_LOYALTY_MAXTIME
    ------------------------------------------
    inst:AddComponent("health")

    ------------------------------------------

    inst:AddComponent("inventory")
    
    ------------------------------------------

    inst:AddComponent("lootdropper")

    ------------------------------------------

    inst:AddComponent("knownlocations")
    inst:AddComponent("talker")
    inst.components.talker.ontalk = ontalk
    

    ------------------------------------------

    inst:AddComponent("sleeper")
    
    ------------------------------------------
    MakeMediumFreezableCharacter(inst, "pig_torso")
    
    ------------------------------------------


    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        if inst:HasTag("guard") then
            return "GUARD"
        elseif inst.components.follower.leader ~= nil then
            return "FOLLOWER"
        end
    end
    ------------------------------------------
   
    
    
    inst.OnSave = function(inst, data)
        data.build = inst.build
        if inst.homepos then
            data.homepos_x=inst.homepos.x
            data.homepos_y=inst.homepos.y
            data.homepos_z=inst.homepos.z
        end
    end        
    
    inst.OnLoad = function(inst, data)    
		if data then
			inst.build = data.build or builds[1]
            inst.AnimState:SetBuild(inst.build)
            if data.homepos_x and data.homepos_y and data.homepos_z then
                inst.homepos=Point(data.homepos_x,data.homepos_y,data.homepos_z)
                inst.components.knownlocations:RememberLocation("home",inst.homepos)
            end
		end
    end           
    inst:ListenForEvent("discovererRemove", DiscoverRemove)
    inst:ListenForEvent("attacked", OnAttacked)    
    inst:ListenForEvent("death", OnDeath)  
    return inst
end


local function discoverer()
    local inst = common()
    inst.build = guardbuilds[math.random(#guardbuilds)]
    inst.AnimState:SetBuild(inst.build)
    SetDisPig(inst)
    return inst
end

return Prefab( "common/characters/discoverer", discoverer, assets, prefabs)
