/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.DevClassPathHelper;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ResourceTranslator {
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";

    public static String getResourceString(Bundle bundle, String value) {
        return ResourceTranslator.getResourceString(bundle, value, null);
    }

    public static String getResourceString(Bundle bundle, String value, ResourceBundle resourceBundle) {
        String dflt;
        String s2 = value.trim();
        if (!s2.startsWith(KEY_PREFIX, 0)) {
            return s2;
        }
        if (s2.startsWith(KEY_DOUBLE_PREFIX, 0)) {
            return s2.substring(1);
        }
        int ix = s2.indexOf(32);
        String key = ix == -1 ? s2 : s2.substring(0, ix);
        String string = dflt = ix == -1 ? s2 : s2.substring(ix + 1);
        if (resourceBundle == null && bundle != null) {
            try {
                resourceBundle = ResourceTranslator.getResourceBundle(bundle);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (resourceBundle == null) {
            return dflt;
        }
        try {
            return resourceBundle.getString(key.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return dflt;
        }
    }

    public static ResourceBundle getResourceBundle(Bundle bundle) throws MissingResourceException {
        return ResourceTranslator.getResourceBundle(bundle, null);
    }

    private static ResourceBundle getResourceBundle(Bundle bundle, String language) throws MissingResourceException {
        if (ResourceTranslator.hasRuntime21(bundle)) {
            Locale locale = language == null ? Locale.getDefault() : new Locale(language);
            return ResourceBundle.getBundle("plugin", locale, ResourceTranslator.createTempClassloader(bundle));
        }
        return Activator.getDefault().getLocalization(bundle, language);
    }

    public static String[] getResourceString(Bundle bundle, String[] nonTranslated, String locale) {
        if (bundle == null) {
            return nonTranslated;
        }
        ResourceBundle resourceBundle = ResourceTranslator.getResourceBundle(bundle, locale);
        String[] translated = new String[nonTranslated.length];
        int i2 = 0;
        while (i2 < nonTranslated.length) {
            translated[i2] = ResourceTranslator.getResourceString(bundle, nonTranslated[i2], resourceBundle);
            ++i2;
        }
        return translated;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasRuntime21(Bundle b2) {
        try {
            ManifestElement[] prereqs = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)b2.getHeaders("").get("Require-Bundle")));
            if (prereqs == null) {
                return false;
            }
            int i2 = 0;
            while (true) {
                if (i2 >= prereqs.length) {
                    return false;
                }
                if ("2.1".equals(prereqs[i2].getAttribute("bundle-version")) && "org.eclipse.core.runtime".equals(prereqs[i2].getValue())) {
                    return true;
                }
                ++i2;
            }
        }
        catch (BundleException bundleException) {
            return false;
        }
    }

    private static ClassLoader createTempClassloader(Bundle b2) {
        ArrayList classpath = new ArrayList();
        ResourceTranslator.addClasspathEntries(b2, classpath);
        ResourceTranslator.addBundleRoot(b2, classpath);
        ResourceTranslator.addDevEntries(b2, classpath);
        ResourceTranslator.addFragments(b2, classpath);
        URL[] urls = new URL[classpath.size()];
        return new URLClassLoader(classpath.toArray(urls));
    }

    private static void addFragments(Bundle host, ArrayList classpath) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return;
        }
        Bundle[] fragments = activator.getFragments(host);
        if (fragments == null) {
            return;
        }
        int i2 = 0;
        while (i2 < fragments.length) {
            ResourceTranslator.addClasspathEntries(fragments[i2], classpath);
            ResourceTranslator.addDevEntries(fragments[i2], classpath);
            ++i2;
        }
    }

    private static void addClasspathEntries(Bundle b2, ArrayList classpath) {
        try {
            ManifestElement[] classpathElements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)b2.getHeaders("").get("Bundle-ClassPath")));
            if (classpathElements == null) {
                return;
            }
            int i2 = 0;
            while (i2 < classpathElements.length) {
                URL classpathEntry = b2.getEntry(classpathElements[i2].getValue());
                if (classpathEntry != null) {
                    classpath.add(classpathEntry);
                }
                ++i2;
            }
        }
        catch (BundleException bundleException) {}
    }

    private static void addBundleRoot(Bundle b2, ArrayList classpath) {
        classpath.add(b2.getEntry("/"));
    }

    private static void addDevEntries(Bundle b2, ArrayList classpath) {
        if (!DevClassPathHelper.inDevelopmentMode()) {
            return;
        }
        String[] binaryPaths = DevClassPathHelper.getDevClassPath(b2.getSymbolicName());
        int i2 = 0;
        while (i2 < binaryPaths.length) {
            URL classpathEntry = b2.getEntry(binaryPaths[i2]);
            if (classpathEntry != null) {
                classpath.add(classpathEntry);
            }
            ++i2;
        }
    }
}

