/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.JNIWrapperException;
import com.jniwrapper.Library;
import com.jniwrapper.LibraryLoader;
import com.jniwrapper.LibraryNotFoundException;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.ag;
import com.jniwrapper.ba;
import com.jniwrapper.bk;
import com.jniwrapper.util.StreamUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLibraryLoader
implements LibraryLoader {
    private static final Logger c = LoggerFactory.getLogger(f == null ? (f = DefaultLibraryLoader.b("com.jniwrapper.DefaultLibraryLoader")) : f);
    private static DefaultLibraryLoader a = null;
    private ba e;
    private static String g = null;
    private String d;
    public static Class f;
    public static Class b;

    private DefaultLibraryLoader() {
        this((f == null ? (f = DefaultLibraryLoader.b("com.jniwrapper.DefaultLibraryLoader")) : f).getClassLoader(), System.getProperty("java.library.path"), Library.NATIVE_CODE);
    }

    public DefaultLibraryLoader(ClassLoader classLoader, String string, String string2) {
        this.e = new ag(classLoader, string, string2);
        this.b();
    }

    private void b() {
        try {
            File file;
            c.debug("DefaultLibraryLoader.generateTmpFolderName");
            String string = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
            c.debug("classContainer = " + string);
            String string2 = this.a(string);
            c.debug("bundleVersion = " + string2);
            String string3 = this.c(string);
            c.debug("jarName = " + string3);
            String string4 = this.a();
            c.debug("systemTempFolder = " + string4);
            boolean bl2 = string4.endsWith(File.separator);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string4);
            if (!bl2) {
                stringBuffer.append(File.separator);
            }
            stringBuffer.append(string3);
            stringBuffer.append(".Build.");
            stringBuffer.append(string2);
            if (bl2) {
                stringBuffer.append(File.separator);
            }
            if (!(file = new File(stringBuffer.toString())).exists() || !file.isDirectory()) {
                if (!file.mkdir()) {
                    this.d = string4;
                    throw new IllegalArgumentException("Cannot create dir: " + file.getAbsolutePath());
                }
                file.deleteOnExit();
            }
            this.d = stringBuffer.toString();
            c.debug("DefaultLibraryLoader.generateTmpFolderName: " + this.d);
        }
        catch (Exception exception) {
            c.debug("Unable to alter tmp folder. Trying to use the system one", exception);
            try {
                this.d = this.a();
            }
            catch (IOException iOException) {
                c.debug("Unable to alter tmp folder.", iOException);
            }
        }
    }

    private String c(String string) {
        c.debug("DefaultLibraryLoader.getJarName from the container: " + string);
        int n2 = string.lastIndexOf("/") + 1;
        String string2 = string.substring(n2);
        int n3 = string2.lastIndexOf(".");
        string2 = string2.substring(0, n3);
        return string2;
    }

    private String a(String string) {
        String string2 = "Unknown";
        try {
            URL uRL = new URL("jar:" + string + "!/META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(uRL.openStream());
            Attributes attributes = manifest.getMainAttributes();
            string2 = attributes.getValue("Bundle-Version");
            if (string2 == null) {
                string2 = attributes.getValue("Version");
            }
        }
        catch (IOException iOException) {
            c.debug("Unable to retrieve version", iOException);
            string2 = "Unknown";
        }
        if (string2 == null) {
            string2 = "Unknown";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a() throws IOException {
        String string;
        try {
            string = PlatformContext.isSnowLeopard() ? "/private/tmp" : System.getProperty("java.io.tmpdir");
        }
        catch (Exception exception) {
            File file = File.createTempFile("~tmp", "");
            try {
                string = file.getParent();
            }
            finally {
                file.delete();
            }
        }
        return string;
    }

    public static DefaultLibraryLoader getInstance() {
        if (a == null) {
            a = new DefaultLibraryLoader();
        }
        return a;
    }

    public void addPath(File file) {
        this.e.b(file);
    }

    public void prependPath(File file) {
        this.e.a(file);
    }

    public void addPath(List list) {
        this.e.a(list);
    }

    public void addPath(String string) {
        this.e.c(string);
    }

    public File findLibrary(String string) {
        Object object;
        boolean bl2;
        String string2 = string;
        boolean bl3 = bl2 = string2.indexOf(Library.NATIVE_CODE) != -1;
        if (!new File(string).isAbsolute()) {
            string2 = DefaultLibraryLoader.mapLibraryName(string);
        }
        c.debug("Finding library " + string2);
        File file = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            c.debug("Class loader of '" + this.getClass() + "' class is null; trying to get context class loader...");
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                c.debug("Context class looader of current thread: " + Thread.currentThread() + " is null; using system class loader...");
                classLoader = ClassLoader.getSystemClassLoader();
            }
        }
        if (classLoader == null) {
            c.error("No available class loaders were found");
            throw new RuntimeException("Could not get any class loader");
        }
        try {
            Enumeration<URL> enumeration = classLoader.getResources(string2);
            while (enumeration.hasMoreElements() && file == null) {
                object = enumeration.nextElement();
                if (object != null && ((URL)object).getProtocol().startsWith("jar")) {
                    c.debug("Looking for library in JAR " + object);
                    file = this.a((URL)object, string2);
                }
                if (file != null || object == null) continue;
                c.debug("Finding library in class path...");
                file = this.a((URL)object);
                if (file == null || !bl2 || bk.a(file)) continue;
                file = null;
            }
        }
        catch (IOException iOException) {
            c.debug("Failed to scan jars for library", iOException);
        }
        if (file == null) {
            c.debug("Finding library in system library path...");
            file = this.e.b(string2);
        }
        if (file == null && PlatformContext.isMacOS()) {
            c.debug("Finding library in system library path on Mac OS X...");
            string2 = !string.endsWith(".dylib") && !string.endsWith(".jnilib") ? string + ".dylib" : string;
            file = this.e.b(string2);
            if (file == null) {
                int n2 = string2.lastIndexOf("/");
                if (n2 > 0) {
                    object = string2.substring(0, n2);
                    string2 = (String)object + "/lib" + string2.substring(n2 + 1);
                } else {
                    string2 = "lib" + string2;
                }
                file = this.e.b(string2);
            }
            return file;
        }
        return file;
    }

    public static String urlToPath(URL uRL) {
        String string = uRL.getFile();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "%", false);
        int n2 = stringTokenizer.countTokens();
        if (n2 > 0) {
            String string2 = stringTokenizer.nextToken();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = string3.substring(0, 2);
                int n3 = Integer.parseInt(string4, 16);
                stringBuffer.append((char)n3);
                stringBuffer.append(string3.substring(2));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void loadLibrary(String string) {
        File file = this.findLibrary(string);
        if (file == null) {
            throw new LibraryNotFoundException("Cannot find library: " + string);
        }
        String string2 = file.getAbsolutePath();
        c.debug("Loading library from " + string2);
        System.load(string2);
    }

    public static String mapLibraryName(String string) {
        if (string.endsWith(DefaultLibraryLoader.getLibraryExtension())) {
            return string;
        }
        if (string.indexOf(".") != -1) {
            return string;
        }
        return System.mapLibraryName(string);
    }

    public static String getLibraryExtension() {
        if (g == null) {
            String string = "FooLibraryName";
            String string2 = System.mapLibraryName("FooLibraryName");
            int n2 = string2.indexOf("FooLibraryName");
            g = n2 == -1 ? "" : string2.substring(n2 + "FooLibraryName".length());
        }
        return g;
    }

    private File a(URL uRL) {
        String string = DefaultLibraryLoader.urlToPath(uRL);
        File file = new File(string);
        return file.exists() && file.isFile() ? file : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File a(URL uRL, String string) {
        File file = null;
        try {
            c.debug("DefaultLibraryLoader.findLibraryInJars. Loading resources to: " + this.d);
            InputStream inputStream = uRL.openStream();
            try {
                file = new File(this.d, string);
                if (file.exists() && !file.delete()) {
                    File file2 = file;
                    return file2;
                }
                file.createNewFile();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    StreamUtils.copy(inputStream, fileOutputStream, 1024);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            JNIWrapperException.throwException(exception);
        }
        file.deleteOnExit();
        if (string.indexOf(Library.NATIVE_CODE) == -1) return file;
        if (bk.a(file)) return file;
        file.delete();
        return null;
    }

    public static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

